<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Reference Data
 * @subpackage Structs
 */
class Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The DUNS
     * Meta information extracted from the WSDL
     * - documentation: DUNS
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUNS;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - documentation: Supplier ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierName
     * Meta information extracted from the WSDL
     * - documentation: Alternate Name with Integration Name Matching Usage
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierName;
    /**
     * Constructor method for
     * Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setDUNS()
     * @uses Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setSupplierID()
     * @uses Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setSupplierName()
     * @param string $dUNS
     * @param string $supplierID
     * @param string $supplierName
     */
    public function __construct($dUNS = null, $supplierID = null, $supplierName = null)
    {
        $this
            ->setDUNS($dUNS)
            ->setSupplierID($supplierID)
            ->setSupplierName($supplierName);
    }
    /**
     * Get DUNS value
     * @return string|null
     */
    public function getDUNS()
    {
        return $this->DUNS;
    }
    /**
     * Set DUNS value
     * @param string $dUNS
     * @return \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setDUNS($dUNS = null)
    {
        // validation for constraint: string
        if (!is_null($dUNS) && !is_string($dUNS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dUNS, true), gettype($dUNS)), __LINE__);
        }
        $this->DUNS = $dUNS;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierName value
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->SupplierName;
    }
    /**
     * Set SupplierName value
     * @param string $supplierName
     * @return \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierName, true), gettype($supplierName)), __LINE__);
        }
        $this->SupplierName = $supplierName;
        return $this;
    }
}
