<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element to capture RFQ Award Line information.
 * @subpackage Structs
 */
class Request_for_Quote_Award_Line_DataType extends AbstractStructBase
{
    /**
     * The RFQ_Award_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Award Line
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_LineObjectType
     */
    public $RFQ_Award_Line_Reference;
    /**
     * The RFQ_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Line
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_LineObjectType
     */
    public $RFQ_Line_Reference;
    /**
     * The RFQ_Response_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Response Line
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Response_LineObjectType
     */
    public $RFQ_Response_Line_Reference;
    /**
     * The Awarded_Document_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Award Outcome Business Document Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_LineObjectType[]
     */
    public $Awarded_Document_Line_Reference;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Line_Number;
    /**
     * The Line_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: RFQ LIne Type Reference
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Line_TypeObjectType
     */
    public $Line_Type_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item on the RFQ Award Line
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description on RFQ Award Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category on the RFQ Award Line
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The RFQ_Line_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Indicates the original RFQ Line Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $RFQ_Line_Quantity;
    /**
     * The RFQ_Line_Quantity_Awarded
     * Meta information extracted from the WSDL
     * - documentation: Indicates how much of the RFQ Line Quantity was awarded
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $RFQ_Line_Quantity_Awarded;
    /**
     * The Award_Quantity
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Line Quantity | Award Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Award_Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure on the RFQ Award Line
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The RFQ_Line_Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Indicates the original RFQ Line Unit Cost
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $RFQ_Line_Unit_Cost;
    /**
     * The RFQ_Line_Amount
     * Meta information extracted from the WSDL
     * - documentation: Indicates original RFQ Line Extended Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $RFQ_Line_Amount;
    /**
     * The Amount_Awarded
     * Meta information extracted from the WSDL
     * - documentation: Indicates how much of the original RFQ Line Amount was awarded
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Amount_Awarded;
    /**
     * The Target_Price
     * Meta information extracted from the WSDL
     * - documentation: Target Price. | Target Price recorded on Request for Quote Line. | Target Price of the RFQ Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Target_Price;
    /**
     * The Response_Price
     * Meta information extracted from the WSDL
     * - documentation: Response Price recorded on RFQ Response Line. | Response Price provided by the supplier. | Response Price on RFQ Response Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Response_Price;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Award_Amount
     * Meta information extracted from the WSDL
     * - documentation: Extended Amount on RFQ Award Line | Award Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Award_Amount;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Requested Delivery Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date on RFQ Award Line. This is applicable only to Service Lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date on RFQ Award Line. This is applicable only to Service Lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Ship-To Address associated with the RFQ Award Line.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Ship-To Contact associated with the RFQ Award Line.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Deliver-To Location associated with the RFQ Award Line.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags on RFQ Award Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Request_for_Quote_Award_Line_Splits_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures RFQ Award Line Splits information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_Line_Splits_DataType[]
     */
    public $Request_for_Quote_Award_Line_Splits_Data;
    /**
     * The Business_Document_Line_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Line_Attachment_Data;
    /**
     * Constructor method for Request_for_Quote_Award_Line_DataType
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Award_Line_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Line_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Response_Line_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setAwarded_Document_Line_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setLine_Number()
     * @uses Request_for_Quote_Award_Line_DataType::setLine_Type_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setItem_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setItem_Description()
     * @uses Request_for_Quote_Award_Line_DataType::setSpend_Category_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Line_Quantity()
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Line_Quantity_Awarded()
     * @uses Request_for_Quote_Award_Line_DataType::setAward_Quantity()
     * @uses Request_for_Quote_Award_Line_DataType::setUnit_of_Measure_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Line_Unit_Cost()
     * @uses Request_for_Quote_Award_Line_DataType::setRFQ_Line_Amount()
     * @uses Request_for_Quote_Award_Line_DataType::setAmount_Awarded()
     * @uses Request_for_Quote_Award_Line_DataType::setTarget_Price()
     * @uses Request_for_Quote_Award_Line_DataType::setResponse_Price()
     * @uses Request_for_Quote_Award_Line_DataType::setUnit_Cost()
     * @uses Request_for_Quote_Award_Line_DataType::setAward_Amount()
     * @uses Request_for_Quote_Award_Line_DataType::setRequested_Delivery_Date()
     * @uses Request_for_Quote_Award_Line_DataType::setStart_Date()
     * @uses Request_for_Quote_Award_Line_DataType::setEnd_Date()
     * @uses Request_for_Quote_Award_Line_DataType::setShip_To_Address_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setShip_To_Contact_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setDeliver_To_Location_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setWorktag_Reference()
     * @uses Request_for_Quote_Award_Line_DataType::setMemo()
     * @uses Request_for_Quote_Award_Line_DataType::setRequest_for_Quote_Award_Line_Splits_Data()
     * @uses Request_for_Quote_Award_Line_DataType::setBusiness_Document_Line_Attachment_Data()
     * @param \StructType\Request_for_Quote_Award_LineObjectType $rFQ_Award_Line_Reference
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @param \StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference
     * @param \StructType\Business_Document_LineObjectType[] $awarded_Document_Line_Reference
     * @param float $line_Number
     * @param \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param string $item_Description
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param float $rFQ_Line_Quantity
     * @param float $rFQ_Line_Quantity_Awarded
     * @param float $award_Quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $rFQ_Line_Unit_Cost
     * @param float $rFQ_Line_Amount
     * @param float $amount_Awarded
     * @param float $target_Price
     * @param float $response_Price
     * @param float $unit_Cost
     * @param float $award_Amount
     * @param string $requested_Delivery_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param string $memo
     * @param \StructType\Request_for_Quote_Award_Line_Splits_DataType[] $request_for_Quote_Award_Line_Splits_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Line_Attachment_Data
     */
    public function __construct(\StructType\Request_for_Quote_Award_LineObjectType $rFQ_Award_Line_Reference = null, \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null, \StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference = null, array $awarded_Document_Line_Reference = array(), $line_Number = null, \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference = null, \StructType\Item_DescriptorObjectType $item_Reference = null, $item_Description = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, $rFQ_Line_Quantity = null, $rFQ_Line_Quantity_Awarded = null, $award_Quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $rFQ_Line_Unit_Cost = null, $rFQ_Line_Amount = null, $amount_Awarded = null, $target_Price = null, $response_Price = null, $unit_Cost = null, $award_Amount = null, $requested_Delivery_Date = null, $start_Date = null, $end_Date = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, array $worktag_Reference = array(), $memo = null, array $request_for_Quote_Award_Line_Splits_Data = array(), array $business_Document_Line_Attachment_Data = array())
    {
        $this
            ->setRFQ_Award_Line_Reference($rFQ_Award_Line_Reference)
            ->setRFQ_Line_Reference($rFQ_Line_Reference)
            ->setRFQ_Response_Line_Reference($rFQ_Response_Line_Reference)
            ->setAwarded_Document_Line_Reference($awarded_Document_Line_Reference)
            ->setLine_Number($line_Number)
            ->setLine_Type_Reference($line_Type_Reference)
            ->setItem_Reference($item_Reference)
            ->setItem_Description($item_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setRFQ_Line_Quantity($rFQ_Line_Quantity)
            ->setRFQ_Line_Quantity_Awarded($rFQ_Line_Quantity_Awarded)
            ->setAward_Quantity($award_Quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setRFQ_Line_Unit_Cost($rFQ_Line_Unit_Cost)
            ->setRFQ_Line_Amount($rFQ_Line_Amount)
            ->setAmount_Awarded($amount_Awarded)
            ->setTarget_Price($target_Price)
            ->setResponse_Price($response_Price)
            ->setUnit_Cost($unit_Cost)
            ->setAward_Amount($award_Amount)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setMemo($memo)
            ->setRequest_for_Quote_Award_Line_Splits_Data($request_for_Quote_Award_Line_Splits_Data)
            ->setBusiness_Document_Line_Attachment_Data($business_Document_Line_Attachment_Data);
    }
    /**
     * Get RFQ_Award_Line_Reference value
     * @return \StructType\Request_for_Quote_Award_LineObjectType|null
     */
    public function getRFQ_Award_Line_Reference()
    {
        return $this->RFQ_Award_Line_Reference;
    }
    /**
     * Set RFQ_Award_Line_Reference value
     * @param \StructType\Request_for_Quote_Award_LineObjectType $rFQ_Award_Line_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Award_Line_Reference(\StructType\Request_for_Quote_Award_LineObjectType $rFQ_Award_Line_Reference = null)
    {
        $this->RFQ_Award_Line_Reference = $rFQ_Award_Line_Reference;
        return $this;
    }
    /**
     * Get RFQ_Line_Reference value
     * @return \StructType\Request_for_Quote_LineObjectType|null
     */
    public function getRFQ_Line_Reference()
    {
        return $this->RFQ_Line_Reference;
    }
    /**
     * Set RFQ_Line_Reference value
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Line_Reference(\StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null)
    {
        $this->RFQ_Line_Reference = $rFQ_Line_Reference;
        return $this;
    }
    /**
     * Get RFQ_Response_Line_Reference value
     * @return \StructType\Request_for_Quote_Response_LineObjectType|null
     */
    public function getRFQ_Response_Line_Reference()
    {
        return $this->RFQ_Response_Line_Reference;
    }
    /**
     * Set RFQ_Response_Line_Reference value
     * @param \StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Response_Line_Reference(\StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference = null)
    {
        $this->RFQ_Response_Line_Reference = $rFQ_Response_Line_Reference;
        return $this;
    }
    /**
     * Get Awarded_Document_Line_Reference value
     * @return \StructType\Business_Document_LineObjectType[]|null
     */
    public function getAwarded_Document_Line_Reference()
    {
        return $this->Awarded_Document_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAwarded_Document_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAwarded_Document_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwarded_Document_Line_ReferenceForArrayConstraintsFromSetAwarded_Document_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_DataTypeAwarded_Document_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_DataTypeAwarded_Document_Line_ReferenceItem instanceof \StructType\Business_Document_LineObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_DataTypeAwarded_Document_Line_ReferenceItem) ? get_class($request_for_Quote_Award_Line_DataTypeAwarded_Document_Line_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_DataTypeAwarded_Document_Line_ReferenceItem), var_export($request_for_Quote_Award_Line_DataTypeAwarded_Document_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Awarded_Document_Line_Reference property can only contain items of type \StructType\Business_Document_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Awarded_Document_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_LineObjectType[] $awarded_Document_Line_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setAwarded_Document_Line_Reference(array $awarded_Document_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($awarded_Document_Line_ReferenceArrayErrorMessage = self::validateAwarded_Document_Line_ReferenceForArrayConstraintsFromSetAwarded_Document_Line_Reference($awarded_Document_Line_Reference))) {
            throw new \InvalidArgumentException($awarded_Document_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Awarded_Document_Line_Reference = $awarded_Document_Line_Reference;
        return $this;
    }
    /**
     * Add item to Awarded_Document_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_LineObjectType $item
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function addToAwarded_Document_Line_Reference(\StructType\Business_Document_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Awarded_Document_Line_Reference property can only contain items of type \StructType\Business_Document_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Awarded_Document_Line_Reference[] = $item;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Line_Type_Reference value
     * @return \StructType\Request_for_Quote_Line_TypeObjectType|null
     */
    public function getLine_Type_Reference()
    {
        return $this->Line_Type_Reference;
    }
    /**
     * Set Line_Type_Reference value
     * @param \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setLine_Type_Reference(\StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference = null)
    {
        $this->Line_Type_Reference = $line_Type_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get RFQ_Line_Quantity value
     * @return float|null
     */
    public function getRFQ_Line_Quantity()
    {
        return $this->RFQ_Line_Quantity;
    }
    /**
     * Set RFQ_Line_Quantity value
     * @param float $rFQ_Line_Quantity
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Line_Quantity($rFQ_Line_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($rFQ_Line_Quantity) && !(is_float($rFQ_Line_Quantity) || is_numeric($rFQ_Line_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rFQ_Line_Quantity, true), gettype($rFQ_Line_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($rFQ_Line_Quantity) && mb_strlen(mb_substr($rFQ_Line_Quantity, false !== mb_strpos($rFQ_Line_Quantity, '.') ? mb_strpos($rFQ_Line_Quantity, '.') + 1 : mb_strlen($rFQ_Line_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($rFQ_Line_Quantity, true), mb_strlen(mb_substr($rFQ_Line_Quantity, mb_strpos($rFQ_Line_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($rFQ_Line_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($rFQ_Line_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Quantity))), __LINE__);
        }
        $this->RFQ_Line_Quantity = $rFQ_Line_Quantity;
        return $this;
    }
    /**
     * Get RFQ_Line_Quantity_Awarded value
     * @return float|null
     */
    public function getRFQ_Line_Quantity_Awarded()
    {
        return $this->RFQ_Line_Quantity_Awarded;
    }
    /**
     * Set RFQ_Line_Quantity_Awarded value
     * @param float $rFQ_Line_Quantity_Awarded
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Line_Quantity_Awarded($rFQ_Line_Quantity_Awarded = null)
    {
        // validation for constraint: float
        if (!is_null($rFQ_Line_Quantity_Awarded) && !(is_float($rFQ_Line_Quantity_Awarded) || is_numeric($rFQ_Line_Quantity_Awarded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rFQ_Line_Quantity_Awarded, true), gettype($rFQ_Line_Quantity_Awarded)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($rFQ_Line_Quantity_Awarded) && mb_strlen(mb_substr($rFQ_Line_Quantity_Awarded, false !== mb_strpos($rFQ_Line_Quantity_Awarded, '.') ? mb_strpos($rFQ_Line_Quantity_Awarded, '.') + 1 : mb_strlen($rFQ_Line_Quantity_Awarded))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($rFQ_Line_Quantity_Awarded, true), mb_strlen(mb_substr($rFQ_Line_Quantity_Awarded, mb_strpos($rFQ_Line_Quantity_Awarded, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rFQ_Line_Quantity_Awarded) && $rFQ_Line_Quantity_Awarded < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rFQ_Line_Quantity_Awarded, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($rFQ_Line_Quantity_Awarded) && mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Quantity_Awarded)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($rFQ_Line_Quantity_Awarded, true), mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Quantity_Awarded))), __LINE__);
        }
        $this->RFQ_Line_Quantity_Awarded = $rFQ_Line_Quantity_Awarded;
        return $this;
    }
    /**
     * Get Award_Quantity value
     * @return float|null
     */
    public function getAward_Quantity()
    {
        return $this->Award_Quantity;
    }
    /**
     * Set Award_Quantity value
     * @param float $award_Quantity
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setAward_Quantity($award_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($award_Quantity) && !(is_float($award_Quantity) || is_numeric($award_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($award_Quantity, true), gettype($award_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($award_Quantity) && mb_strlen(mb_substr($award_Quantity, false !== mb_strpos($award_Quantity, '.') ? mb_strpos($award_Quantity, '.') + 1 : mb_strlen($award_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($award_Quantity, true), mb_strlen(mb_substr($award_Quantity, mb_strpos($award_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($award_Quantity) && $award_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($award_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($award_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $award_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($award_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $award_Quantity))), __LINE__);
        }
        $this->Award_Quantity = $award_Quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get RFQ_Line_Unit_Cost value
     * @return float|null
     */
    public function getRFQ_Line_Unit_Cost()
    {
        return $this->RFQ_Line_Unit_Cost;
    }
    /**
     * Set RFQ_Line_Unit_Cost value
     * @param float $rFQ_Line_Unit_Cost
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Line_Unit_Cost($rFQ_Line_Unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($rFQ_Line_Unit_Cost) && !(is_float($rFQ_Line_Unit_Cost) || is_numeric($rFQ_Line_Unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rFQ_Line_Unit_Cost, true), gettype($rFQ_Line_Unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($rFQ_Line_Unit_Cost) && mb_strlen(mb_substr($rFQ_Line_Unit_Cost, false !== mb_strpos($rFQ_Line_Unit_Cost, '.') ? mb_strpos($rFQ_Line_Unit_Cost, '.') + 1 : mb_strlen($rFQ_Line_Unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($rFQ_Line_Unit_Cost, true), mb_strlen(mb_substr($rFQ_Line_Unit_Cost, mb_strpos($rFQ_Line_Unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rFQ_Line_Unit_Cost) && $rFQ_Line_Unit_Cost < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rFQ_Line_Unit_Cost, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($rFQ_Line_Unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($rFQ_Line_Unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Unit_Cost))), __LINE__);
        }
        $this->RFQ_Line_Unit_Cost = $rFQ_Line_Unit_Cost;
        return $this;
    }
    /**
     * Get RFQ_Line_Amount value
     * @return float|null
     */
    public function getRFQ_Line_Amount()
    {
        return $this->RFQ_Line_Amount;
    }
    /**
     * Set RFQ_Line_Amount value
     * @param float $rFQ_Line_Amount
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRFQ_Line_Amount($rFQ_Line_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($rFQ_Line_Amount) && !(is_float($rFQ_Line_Amount) || is_numeric($rFQ_Line_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rFQ_Line_Amount, true), gettype($rFQ_Line_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($rFQ_Line_Amount) && mb_strlen(mb_substr($rFQ_Line_Amount, false !== mb_strpos($rFQ_Line_Amount, '.') ? mb_strpos($rFQ_Line_Amount, '.') + 1 : mb_strlen($rFQ_Line_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($rFQ_Line_Amount, true), mb_strlen(mb_substr($rFQ_Line_Amount, mb_strpos($rFQ_Line_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($rFQ_Line_Amount) && mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($rFQ_Line_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Amount))), __LINE__);
        }
        $this->RFQ_Line_Amount = $rFQ_Line_Amount;
        return $this;
    }
    /**
     * Get Amount_Awarded value
     * @return float|null
     */
    public function getAmount_Awarded()
    {
        return $this->Amount_Awarded;
    }
    /**
     * Set Amount_Awarded value
     * @param float $amount_Awarded
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setAmount_Awarded($amount_Awarded = null)
    {
        // validation for constraint: float
        if (!is_null($amount_Awarded) && !(is_float($amount_Awarded) || is_numeric($amount_Awarded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_Awarded, true), gettype($amount_Awarded)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount_Awarded) && mb_strlen(mb_substr($amount_Awarded, false !== mb_strpos($amount_Awarded, '.') ? mb_strpos($amount_Awarded, '.') + 1 : mb_strlen($amount_Awarded))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount_Awarded, true), mb_strlen(mb_substr($amount_Awarded, mb_strpos($amount_Awarded, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($amount_Awarded) && $amount_Awarded < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($amount_Awarded, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($amount_Awarded) && mb_strlen(preg_replace('/(\D)/', '', $amount_Awarded)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($amount_Awarded, true), mb_strlen(preg_replace('/(\D)/', '', $amount_Awarded))), __LINE__);
        }
        $this->Amount_Awarded = $amount_Awarded;
        return $this;
    }
    /**
     * Get Target_Price value
     * @return float|null
     */
    public function getTarget_Price()
    {
        return $this->Target_Price;
    }
    /**
     * Set Target_Price value
     * @param float $target_Price
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setTarget_Price($target_Price = null)
    {
        // validation for constraint: float
        if (!is_null($target_Price) && !(is_float($target_Price) || is_numeric($target_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($target_Price, true), gettype($target_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($target_Price) && mb_strlen(mb_substr($target_Price, false !== mb_strpos($target_Price, '.') ? mb_strpos($target_Price, '.') + 1 : mb_strlen($target_Price))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($target_Price, true), mb_strlen(mb_substr($target_Price, mb_strpos($target_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($target_Price) && $target_Price < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($target_Price, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($target_Price) && mb_strlen(preg_replace('/(\D)/', '', $target_Price)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($target_Price, true), mb_strlen(preg_replace('/(\D)/', '', $target_Price))), __LINE__);
        }
        $this->Target_Price = $target_Price;
        return $this;
    }
    /**
     * Get Response_Price value
     * @return float|null
     */
    public function getResponse_Price()
    {
        return $this->Response_Price;
    }
    /**
     * Set Response_Price value
     * @param float $response_Price
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setResponse_Price($response_Price = null)
    {
        // validation for constraint: float
        if (!is_null($response_Price) && !(is_float($response_Price) || is_numeric($response_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($response_Price, true), gettype($response_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($response_Price) && mb_strlen(mb_substr($response_Price, false !== mb_strpos($response_Price, '.') ? mb_strpos($response_Price, '.') + 1 : mb_strlen($response_Price))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($response_Price, true), mb_strlen(mb_substr($response_Price, mb_strpos($response_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($response_Price) && $response_Price < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($response_Price, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($response_Price) && mb_strlen(preg_replace('/(\D)/', '', $response_Price)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($response_Price, true), mb_strlen(preg_replace('/(\D)/', '', $response_Price))), __LINE__);
        }
        $this->Response_Price = $response_Price;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Award_Amount value
     * @return float|null
     */
    public function getAward_Amount()
    {
        return $this->Award_Amount;
    }
    /**
     * Set Award_Amount value
     * @param float $award_Amount
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setAward_Amount($award_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($award_Amount) && !(is_float($award_Amount) || is_numeric($award_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($award_Amount, true), gettype($award_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($award_Amount) && mb_strlen(mb_substr($award_Amount, false !== mb_strpos($award_Amount, '.') ? mb_strpos($award_Amount, '.') + 1 : mb_strlen($award_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($award_Amount, true), mb_strlen(mb_substr($award_Amount, mb_strpos($award_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($award_Amount) && mb_strlen(preg_replace('/(\D)/', '', $award_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($award_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $award_Amount))), __LINE__);
        }
        $this->Award_Amount = $award_Amount;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_DataTypeWorktag_ReferenceItem) ? get_class($request_for_Quote_Award_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_DataTypeWorktag_ReferenceItem), var_export($request_for_Quote_Award_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Request_for_Quote_Award_Line_Splits_Data value
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType[]|null
     */
    public function getRequest_for_Quote_Award_Line_Splits_Data()
    {
        return $this->Request_for_Quote_Award_Line_Splits_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award_Line_Splits_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award_Line_Splits_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Award_Line_Splits_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Splits_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_DataTypeRequest_for_Quote_Award_Line_Splits_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_DataTypeRequest_for_Quote_Award_Line_Splits_DataItem instanceof \StructType\Request_for_Quote_Award_Line_Splits_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_DataTypeRequest_for_Quote_Award_Line_Splits_DataItem) ? get_class($request_for_Quote_Award_Line_DataTypeRequest_for_Quote_Award_Line_Splits_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_DataTypeRequest_for_Quote_Award_Line_Splits_DataItem), var_export($request_for_Quote_Award_Line_DataTypeRequest_for_Quote_Award_Line_Splits_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award_Line_Splits_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_Splits_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_Splits_DataType[] $request_for_Quote_Award_Line_Splits_Data
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setRequest_for_Quote_Award_Line_Splits_Data(array $request_for_Quote_Award_Line_Splits_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Award_Line_Splits_DataArrayErrorMessage = self::validateRequest_for_Quote_Award_Line_Splits_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Splits_Data($request_for_Quote_Award_Line_Splits_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Award_Line_Splits_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Splits_Data = $request_for_Quote_Award_Line_Splits_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_Splits_DataType $item
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function addToRequest_for_Quote_Award_Line_Splits_Data(\StructType\Request_for_Quote_Award_Line_Splits_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Award_Line_Splits_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award_Line_Splits_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_Splits_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Splits_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Line_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Line_Attachment_Data()
    {
        return $this->Business_Document_Line_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Line_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Line_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Line_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Line_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_DataTypeBusiness_Document_Line_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_DataTypeBusiness_Document_Line_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_DataTypeBusiness_Document_Line_Attachment_DataItem) ? get_class($request_for_Quote_Award_Line_DataTypeBusiness_Document_Line_Attachment_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_DataTypeBusiness_Document_Line_Attachment_DataItem), var_export($request_for_Quote_Award_Line_DataTypeBusiness_Document_Line_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Line_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Line_Attachment_Data
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function setBusiness_Document_Line_Attachment_Data(array $business_Document_Line_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Line_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Line_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Line_Attachment_Data($business_Document_Line_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Line_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Line_Attachment_Data = $business_Document_Line_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Request_for_Quote_Award_Line_DataType
     */
    public function addToBusiness_Document_Line_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Line_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Line_Attachment_Data[] = $item;
        return $this;
    }
}
