<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Register_Asset_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Response on the Put operation.
 * @subpackage Structs
 */
class Register_Asset_ResponseType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Asset
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Exceptions_Response_Data
     * Meta information extracted from the WSDL
     * - documentation: Exceptions Response Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Application_Instance_Related_Exceptions_DataType[]
     */
    public $Exceptions_Response_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Register_Asset_ResponseType
     * @uses Register_Asset_ResponseType::setBusiness_Asset_Reference()
     * @uses Register_Asset_ResponseType::setExceptions_Response_Data()
     * @uses Register_Asset_ResponseType::setVersion()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $exceptions_Response_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, array $exceptions_Response_Data = array(), $version = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setExceptions_Response_Data($exceptions_Response_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Register_Asset_ResponseType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Exceptions_Response_Data value
     * @return \StructType\Application_Instance_Related_Exceptions_DataType[]|null
     */
    public function getExceptions_Response_Data()
    {
        return $this->Exceptions_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExceptions_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExceptions_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExceptions_Response_DataForArrayConstraintsFromSetExceptions_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $register_Asset_ResponseTypeExceptions_Response_DataItem) {
            // validation for constraint: itemType
            if (!$register_Asset_ResponseTypeExceptions_Response_DataItem instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
                $invalidValues[] = is_object($register_Asset_ResponseTypeExceptions_Response_DataItem) ? get_class($register_Asset_ResponseTypeExceptions_Response_DataItem) : sprintf('%s(%s)', gettype($register_Asset_ResponseTypeExceptions_Response_DataItem), var_export($register_Asset_ResponseTypeExceptions_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Exceptions_Response_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Exceptions_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $exceptions_Response_Data
     * @return \StructType\Register_Asset_ResponseType
     */
    public function setExceptions_Response_Data(array $exceptions_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($exceptions_Response_DataArrayErrorMessage = self::validateExceptions_Response_DataForArrayConstraintsFromSetExceptions_Response_Data($exceptions_Response_Data))) {
            throw new \InvalidArgumentException($exceptions_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->Exceptions_Response_Data = $exceptions_Response_Data;
        return $this;
    }
    /**
     * Add item to Exceptions_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType $item
     * @return \StructType\Register_Asset_ResponseType
     */
    public function addToExceptions_Response_Data(\StructType\Application_Instance_Related_Exceptions_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
            throw new \InvalidArgumentException(sprintf('The Exceptions_Response_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Exceptions_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Register_Asset_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
