<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_External_Reference_on_Spend_Transaction_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Request Element that contains a reference to the Spend Transaction that will be updated to set External System ID Reference and External Source Reference ID.
 * @subpackage Structs
 */
class Put_External_Reference_on_Spend_Transaction_RequestType extends AbstractStructBase
{
    /**
     * The Spend_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Transaction Reference to update External Transaction Source and External Reference ID.
     * @var \StructType\External_Sourceable_AbstractObjectType
     */
    public $Spend_Transaction_Reference;
    /**
     * The External_Source_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID of the spend transaction in the originating system.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Source_Reference_ID;
    /**
     * The External_System_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the External System from which this transaction originated from.
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $External_System_ID_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_External_Reference_on_Spend_Transaction_RequestType
     * @uses Put_External_Reference_on_Spend_Transaction_RequestType::setSpend_Transaction_Reference()
     * @uses Put_External_Reference_on_Spend_Transaction_RequestType::setExternal_Source_Reference_ID()
     * @uses Put_External_Reference_on_Spend_Transaction_RequestType::setExternal_System_ID_Reference()
     * @uses Put_External_Reference_on_Spend_Transaction_RequestType::setVersion()
     * @param \StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference
     * @param string $external_Source_Reference_ID
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference
     * @param string $version
     */
    public function __construct(\StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference = null, $external_Source_Reference_ID = null, \StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference = null, $version = null)
    {
        $this
            ->setSpend_Transaction_Reference($spend_Transaction_Reference)
            ->setExternal_Source_Reference_ID($external_Source_Reference_ID)
            ->setExternal_System_ID_Reference($external_System_ID_Reference)
            ->setVersion($version);
    }
    /**
     * Get Spend_Transaction_Reference value
     * @return \StructType\External_Sourceable_AbstractObjectType|null
     */
    public function getSpend_Transaction_Reference()
    {
        return $this->Spend_Transaction_Reference;
    }
    /**
     * Set Spend_Transaction_Reference value
     * @param \StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_RequestType
     */
    public function setSpend_Transaction_Reference(\StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference = null)
    {
        $this->Spend_Transaction_Reference = $spend_Transaction_Reference;
        return $this;
    }
    /**
     * Get External_Source_Reference_ID value
     * @return string|null
     */
    public function getExternal_Source_Reference_ID()
    {
        return $this->External_Source_Reference_ID;
    }
    /**
     * Set External_Source_Reference_ID value
     * @param string $external_Source_Reference_ID
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_RequestType
     */
    public function setExternal_Source_Reference_ID($external_Source_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($external_Source_Reference_ID) && !is_string($external_Source_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Source_Reference_ID, true), gettype($external_Source_Reference_ID)), __LINE__);
        }
        $this->External_Source_Reference_ID = $external_Source_Reference_ID;
        return $this;
    }
    /**
     * Get External_System_ID_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getExternal_System_ID_Reference()
    {
        return $this->External_System_ID_Reference;
    }
    /**
     * Set External_System_ID_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_RequestType
     */
    public function setExternal_System_ID_Reference(\StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference = null)
    {
        $this->External_System_ID_Reference = $external_System_ID_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
