<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_TimesheetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Timesheet
 * @subpackage Structs
 */
class Project_TimesheetType extends AbstractStructBase
{
    /**
     * The Project_Timesheet_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to this timesheet object.
     * - minOccurs: 0
     * @var \StructType\Project_TimesheetObjectType
     */
    public $Project_Timesheet_Reference;
    /**
     * The Project_Timesheet_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulates all the data for a Project Timesheet
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Timesheet_DataType[]
     */
    public $Project_Timesheet_Data;
    /**
     * Constructor method for Project_TimesheetType
     * @uses Project_TimesheetType::setProject_Timesheet_Reference()
     * @uses Project_TimesheetType::setProject_Timesheet_Data()
     * @param \StructType\Project_TimesheetObjectType $project_Timesheet_Reference
     * @param \StructType\Project_Timesheet_DataType[] $project_Timesheet_Data
     */
    public function __construct(\StructType\Project_TimesheetObjectType $project_Timesheet_Reference = null, array $project_Timesheet_Data = array())
    {
        $this
            ->setProject_Timesheet_Reference($project_Timesheet_Reference)
            ->setProject_Timesheet_Data($project_Timesheet_Data);
    }
    /**
     * Get Project_Timesheet_Reference value
     * @return \StructType\Project_TimesheetObjectType|null
     */
    public function getProject_Timesheet_Reference()
    {
        return $this->Project_Timesheet_Reference;
    }
    /**
     * Set Project_Timesheet_Reference value
     * @param \StructType\Project_TimesheetObjectType $project_Timesheet_Reference
     * @return \StructType\Project_TimesheetType
     */
    public function setProject_Timesheet_Reference(\StructType\Project_TimesheetObjectType $project_Timesheet_Reference = null)
    {
        $this->Project_Timesheet_Reference = $project_Timesheet_Reference;
        return $this;
    }
    /**
     * Get Project_Timesheet_Data value
     * @return \StructType\Project_Timesheet_DataType[]|null
     */
    public function getProject_Timesheet_Data()
    {
        return $this->Project_Timesheet_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Timesheet_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Timesheet_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Timesheet_DataForArrayConstraintsFromSetProject_Timesheet_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_TimesheetTypeProject_Timesheet_DataItem) {
            // validation for constraint: itemType
            if (!$project_TimesheetTypeProject_Timesheet_DataItem instanceof \StructType\Project_Timesheet_DataType) {
                $invalidValues[] = is_object($project_TimesheetTypeProject_Timesheet_DataItem) ? get_class($project_TimesheetTypeProject_Timesheet_DataItem) : sprintf('%s(%s)', gettype($project_TimesheetTypeProject_Timesheet_DataItem), var_export($project_TimesheetTypeProject_Timesheet_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Timesheet_Data property can only contain items of type \StructType\Project_Timesheet_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Timesheet_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Timesheet_DataType[] $project_Timesheet_Data
     * @return \StructType\Project_TimesheetType
     */
    public function setProject_Timesheet_Data(array $project_Timesheet_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Timesheet_DataArrayErrorMessage = self::validateProject_Timesheet_DataForArrayConstraintsFromSetProject_Timesheet_Data($project_Timesheet_Data))) {
            throw new \InvalidArgumentException($project_Timesheet_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Timesheet_Data = $project_Timesheet_Data;
        return $this;
    }
    /**
     * Add item to Project_Timesheet_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Timesheet_DataType $item
     * @return \StructType\Project_TimesheetType
     */
    public function addToProject_Timesheet_Data(\StructType\Project_Timesheet_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Timesheet_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Timesheet_Data property can only contain items of type \StructType\Project_Timesheet_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Timesheet_Data[] = $item;
        return $this;
    }
}
