<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Group_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Expense Item Group data
 * @subpackage Structs
 */
class Expense_Item_Group_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_Group_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Group ID. This is the Expense Item Group unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Item_Group_ID;
    /**
     * The Expense_Item_Group_Name
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Group Name is already used. | Free form text for a meaningful Expense Item Group Name
     * - maxOccurs: 1
     * @var string
     */
    public $Expense_Item_Group_Name;
    /**
     * Constructor method for Expense_Item_Group_DataType
     * @uses Expense_Item_Group_DataType::setExpense_Item_Group_ID()
     * @uses Expense_Item_Group_DataType::setExpense_Item_Group_Name()
     * @param string $expense_Item_Group_ID
     * @param string $expense_Item_Group_Name
     */
    public function __construct($expense_Item_Group_ID = null, $expense_Item_Group_Name = null)
    {
        $this
            ->setExpense_Item_Group_ID($expense_Item_Group_ID)
            ->setExpense_Item_Group_Name($expense_Item_Group_Name);
    }
    /**
     * Get Expense_Item_Group_ID value
     * @return string|null
     */
    public function getExpense_Item_Group_ID()
    {
        return $this->Expense_Item_Group_ID;
    }
    /**
     * Set Expense_Item_Group_ID value
     * @param string $expense_Item_Group_ID
     * @return \StructType\Expense_Item_Group_DataType
     */
    public function setExpense_Item_Group_ID($expense_Item_Group_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_Group_ID) && !is_string($expense_Item_Group_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_Group_ID, true), gettype($expense_Item_Group_ID)), __LINE__);
        }
        $this->Expense_Item_Group_ID = $expense_Item_Group_ID;
        return $this;
    }
    /**
     * Get Expense_Item_Group_Name value
     * @return string|null
     */
    public function getExpense_Item_Group_Name()
    {
        return $this->Expense_Item_Group_Name;
    }
    /**
     * Set Expense_Item_Group_Name value
     * @param string $expense_Item_Group_Name
     * @return \StructType\Expense_Item_Group_DataType
     */
    public function setExpense_Item_Group_Name($expense_Item_Group_Name = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_Group_Name) && !is_string($expense_Item_Group_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_Group_Name, true), gettype($expense_Item_Group_Name)), __LINE__);
        }
        $this->Expense_Item_Group_Name = $expense_Item_Group_Name;
        return $this;
    }
}
