<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Item_Data_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Catalog Item Data Data
 * @subpackage Structs
 */
class Catalog_Item_Data_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Item_Pricing_Data_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective date of the Catalog Item Data used for pricing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Pricing_Data_Effective_Date;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ordering unit of measure of catalog item pricing history instance.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Price of Catalog Item starting on the Effective Date. | Item Unit Price | Unit Cost of Purchase Item for the corresponding UOM. | Unit Price. | Unit Price for Advanced Pricing Rule. The currency is the same as the supplier
     * information detail. | Unit Price for the JIT UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items. | Unit Price of the Ordering UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Price;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Default_Unit_of_Measure
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this Unit of Measure is the default UOM.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_Unit_of_Measure;
    /**
     * The Just_In_Time
     * Meta information extracted from the WSDL
     * - documentation: Just In Time flag for the UOM for this Catalog Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Just_In_Time;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Minimum_Order_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Minimum Order Quantity for the UOM for this Catalog Item | The Minimum Order Quantity for a given UOM for the Catalog Item Pricing History. | The minimum quantity per unit of measure for Item. A value of zero means that there is no
     * minimum order quantity. | Supplier requires this minimum quantity to be met when you order in this unit of measure to avoid penalties. If this is for a Just in Time unit of measure, no minimum quantity is allowed. | Minimum order quantity. This field
     * can only be updated for catalog items when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Minimum_Order_Quantity;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Unit of Measure is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Catalog_Item_Data_DataType
     * @uses Catalog_Item_Data_DataType::setSupplier_Item_Pricing_Data_Effective_Date()
     * @uses Catalog_Item_Data_DataType::setUnit_of_Measure_Reference()
     * @uses Catalog_Item_Data_DataType::setUnit_Price()
     * @uses Catalog_Item_Data_DataType::setConversion_Factor()
     * @uses Catalog_Item_Data_DataType::setDefault_Unit_of_Measure()
     * @uses Catalog_Item_Data_DataType::setJust_In_Time()
     * @uses Catalog_Item_Data_DataType::setLead_Time()
     * @uses Catalog_Item_Data_DataType::setMinimum_Order_Quantity()
     * @uses Catalog_Item_Data_DataType::setInactive()
     * @param string $supplier_Item_Pricing_Data_Effective_Date
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Price
     * @param float $conversion_Factor
     * @param bool $default_Unit_of_Measure
     * @param bool $just_In_Time
     * @param float $lead_Time
     * @param float $minimum_Order_Quantity
     * @param bool $inactive
     */
    public function __construct($supplier_Item_Pricing_Data_Effective_Date = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Price = null, $conversion_Factor = null, $default_Unit_of_Measure = null, $just_In_Time = null, $lead_Time = null, $minimum_Order_Quantity = null, $inactive = null)
    {
        $this
            ->setSupplier_Item_Pricing_Data_Effective_Date($supplier_Item_Pricing_Data_Effective_Date)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Price($unit_Price)
            ->setConversion_Factor($conversion_Factor)
            ->setDefault_Unit_of_Measure($default_Unit_of_Measure)
            ->setJust_In_Time($just_In_Time)
            ->setLead_Time($lead_Time)
            ->setMinimum_Order_Quantity($minimum_Order_Quantity)
            ->setInactive($inactive);
    }
    /**
     * Get Supplier_Item_Pricing_Data_Effective_Date value
     * @return string|null
     */
    public function getSupplier_Item_Pricing_Data_Effective_Date()
    {
        return $this->Supplier_Item_Pricing_Data_Effective_Date;
    }
    /**
     * Set Supplier_Item_Pricing_Data_Effective_Date value
     * @param string $supplier_Item_Pricing_Data_Effective_Date
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setSupplier_Item_Pricing_Data_Effective_Date($supplier_Item_Pricing_Data_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Pricing_Data_Effective_Date) && !is_string($supplier_Item_Pricing_Data_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Pricing_Data_Effective_Date, true), gettype($supplier_Item_Pricing_Data_Effective_Date)), __LINE__);
        }
        $this->Supplier_Item_Pricing_Data_Effective_Date = $supplier_Item_Pricing_Data_Effective_Date;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Price value
     * @return float|null
     */
    public function getUnit_Price()
    {
        return $this->Unit_Price;
    }
    /**
     * Set Unit_Price value
     * @param float $unit_Price
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setUnit_Price($unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Price) && !(is_float($unit_Price) || is_numeric($unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Price, true), gettype($unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Price) && mb_strlen(mb_substr($unit_Price, false !== mb_strpos($unit_Price, '.') ? mb_strpos($unit_Price, '.') + 1 : mb_strlen($unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Price, true), mb_strlen(mb_substr($unit_Price, mb_strpos($unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Price))), __LINE__);
        }
        $this->Unit_Price = $unit_Price;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Default_Unit_of_Measure value
     * @return bool|null
     */
    public function getDefault_Unit_of_Measure()
    {
        return $this->Default_Unit_of_Measure;
    }
    /**
     * Set Default_Unit_of_Measure value
     * @param bool $default_Unit_of_Measure
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setDefault_Unit_of_Measure($default_Unit_of_Measure = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_Unit_of_Measure) && !is_bool($default_Unit_of_Measure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_Unit_of_Measure, true), gettype($default_Unit_of_Measure)), __LINE__);
        }
        $this->Default_Unit_of_Measure = $default_Unit_of_Measure;
        return $this;
    }
    /**
     * Get Just_In_Time value
     * @return bool|null
     */
    public function getJust_In_Time()
    {
        return $this->Just_In_Time;
    }
    /**
     * Set Just_In_Time value
     * @param bool $just_In_Time
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setJust_In_Time($just_In_Time = null)
    {
        // validation for constraint: boolean
        if (!is_null($just_In_Time) && !is_bool($just_In_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($just_In_Time, true), gettype($just_In_Time)), __LINE__);
        }
        $this->Just_In_Time = $just_In_Time;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Minimum_Order_Quantity value
     * @return float|null
     */
    public function getMinimum_Order_Quantity()
    {
        return $this->Minimum_Order_Quantity;
    }
    /**
     * Set Minimum_Order_Quantity value
     * @param float $minimum_Order_Quantity
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setMinimum_Order_Quantity($minimum_Order_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Order_Quantity) && !(is_float($minimum_Order_Quantity) || is_numeric($minimum_Order_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Order_Quantity, true), gettype($minimum_Order_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($minimum_Order_Quantity) && mb_strlen(mb_substr($minimum_Order_Quantity, false !== mb_strpos($minimum_Order_Quantity, '.') ? mb_strpos($minimum_Order_Quantity, '.') + 1 : mb_strlen($minimum_Order_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($minimum_Order_Quantity, true), mb_strlen(mb_substr($minimum_Order_Quantity, mb_strpos($minimum_Order_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($minimum_Order_Quantity) && $minimum_Order_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($minimum_Order_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($minimum_Order_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Order_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($minimum_Order_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Order_Quantity))), __LINE__);
        }
        $this->Minimum_Order_Quantity = $minimum_Order_Quantity;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Catalog_Item_Data_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
