<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_TemplateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Worktag Split Template Instance and Data
 * @subpackage Structs
 */
class Worktag_Split_TemplateType extends AbstractStructBase
{
    /**
     * The Worktag_Split_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Worktag Split Template
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_TemplateObjectType
     */
    public $Worktag_Split_Template_Reference;
    /**
     * The Worktag_Split_Template_Data
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_Template_DataType[]
     */
    public $Worktag_Split_Template_Data;
    /**
     * Constructor method for Worktag_Split_TemplateType
     * @uses Worktag_Split_TemplateType::setWorktag_Split_Template_Reference()
     * @uses Worktag_Split_TemplateType::setWorktag_Split_Template_Data()
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @param \StructType\Worktag_Split_Template_DataType[] $worktag_Split_Template_Data
     */
    public function __construct(\StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null, array $worktag_Split_Template_Data = array())
    {
        $this
            ->setWorktag_Split_Template_Reference($worktag_Split_Template_Reference)
            ->setWorktag_Split_Template_Data($worktag_Split_Template_Data);
    }
    /**
     * Get Worktag_Split_Template_Reference value
     * @return \StructType\Worktag_Split_TemplateObjectType|null
     */
    public function getWorktag_Split_Template_Reference()
    {
        return $this->Worktag_Split_Template_Reference;
    }
    /**
     * Set Worktag_Split_Template_Reference value
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @return \StructType\Worktag_Split_TemplateType
     */
    public function setWorktag_Split_Template_Reference(\StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null)
    {
        $this->Worktag_Split_Template_Reference = $worktag_Split_Template_Reference;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Data value
     * @return \StructType\Worktag_Split_Template_DataType[]|null
     */
    public function getWorktag_Split_Template_Data()
    {
        return $this->Worktag_Split_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Split_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Split_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_Split_Template_DataForArrayConstraintsFromSetWorktag_Split_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_TemplateTypeWorktag_Split_Template_DataItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_TemplateTypeWorktag_Split_Template_DataItem instanceof \StructType\Worktag_Split_Template_DataType) {
                $invalidValues[] = is_object($worktag_Split_TemplateTypeWorktag_Split_Template_DataItem) ? get_class($worktag_Split_TemplateTypeWorktag_Split_Template_DataItem) : sprintf('%s(%s)', gettype($worktag_Split_TemplateTypeWorktag_Split_Template_DataItem), var_export($worktag_Split_TemplateTypeWorktag_Split_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Split_Template_Data property can only contain items of type \StructType\Worktag_Split_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Split_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worktag_Split_Template_DataType[] $worktag_Split_Template_Data
     * @return \StructType\Worktag_Split_TemplateType
     */
    public function setWorktag_Split_Template_Data(array $worktag_Split_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_Split_Template_DataArrayErrorMessage = self::validateWorktag_Split_Template_DataForArrayConstraintsFromSetWorktag_Split_Template_Data($worktag_Split_Template_Data))) {
            throw new \InvalidArgumentException($worktag_Split_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Split_Template_Data = $worktag_Split_Template_Data;
        return $this;
    }
    /**
     * Add item to Worktag_Split_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worktag_Split_Template_DataType $item
     * @return \StructType\Worktag_Split_TemplateType
     */
    public function addToWorktag_Split_Template_Data(\StructType\Worktag_Split_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worktag_Split_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Split_Template_Data property can only contain items of type \StructType\Worktag_Split_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Split_Template_Data[] = $item;
        return $this;
    }
}
