<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimesheetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the response data for the Get_Timesheet operation.
 * @subpackage Structs
 */
class TimesheetType extends AbstractStructBase
{
    /**
     * The Timesheet_Reference
     * Meta information extracted from the WSDL
     * - documentation: Timesheet reference that will be returned as part of the response for the Get_Timesheet operation.
     * - minOccurs: 0
     * @var \StructType\TimesheetObjectType
     */
    public $Timesheet_Reference;
    /**
     * The Timesheet_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that contains Worker Time Card (Timesheet) Data.
     * - minOccurs: 0
     * @var \StructType\Worker_Time_Card_WWS_DataType
     */
    public $Timesheet_Data;
    /**
     * The Timesheet_Daily_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that contains Timesheet Day details for a Timesheet for a Get_Timesheet operation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Timesheet_Daily_WWS_DataType[]
     */
    public $Timesheet_Daily_Data;
    /**
     * Constructor method for TimesheetType
     * @uses TimesheetType::setTimesheet_Reference()
     * @uses TimesheetType::setTimesheet_Data()
     * @uses TimesheetType::setTimesheet_Daily_Data()
     * @param \StructType\TimesheetObjectType $timesheet_Reference
     * @param \StructType\Worker_Time_Card_WWS_DataType $timesheet_Data
     * @param \StructType\Timesheet_Daily_WWS_DataType[] $timesheet_Daily_Data
     */
    public function __construct(\StructType\TimesheetObjectType $timesheet_Reference = null, \StructType\Worker_Time_Card_WWS_DataType $timesheet_Data = null, array $timesheet_Daily_Data = array())
    {
        $this
            ->setTimesheet_Reference($timesheet_Reference)
            ->setTimesheet_Data($timesheet_Data)
            ->setTimesheet_Daily_Data($timesheet_Daily_Data);
    }
    /**
     * Get Timesheet_Reference value
     * @return \StructType\TimesheetObjectType|null
     */
    public function getTimesheet_Reference()
    {
        return $this->Timesheet_Reference;
    }
    /**
     * Set Timesheet_Reference value
     * @param \StructType\TimesheetObjectType $timesheet_Reference
     * @return \StructType\TimesheetType
     */
    public function setTimesheet_Reference(\StructType\TimesheetObjectType $timesheet_Reference = null)
    {
        $this->Timesheet_Reference = $timesheet_Reference;
        return $this;
    }
    /**
     * Get Timesheet_Data value
     * @return \StructType\Worker_Time_Card_WWS_DataType|null
     */
    public function getTimesheet_Data()
    {
        return $this->Timesheet_Data;
    }
    /**
     * Set Timesheet_Data value
     * @param \StructType\Worker_Time_Card_WWS_DataType $timesheet_Data
     * @return \StructType\TimesheetType
     */
    public function setTimesheet_Data(\StructType\Worker_Time_Card_WWS_DataType $timesheet_Data = null)
    {
        $this->Timesheet_Data = $timesheet_Data;
        return $this;
    }
    /**
     * Get Timesheet_Daily_Data value
     * @return \StructType\Timesheet_Daily_WWS_DataType[]|null
     */
    public function getTimesheet_Daily_Data()
    {
        return $this->Timesheet_Daily_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTimesheet_Daily_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimesheet_Daily_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimesheet_Daily_DataForArrayConstraintsFromSetTimesheet_Daily_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheetTypeTimesheet_Daily_DataItem) {
            // validation for constraint: itemType
            if (!$timesheetTypeTimesheet_Daily_DataItem instanceof \StructType\Timesheet_Daily_WWS_DataType) {
                $invalidValues[] = is_object($timesheetTypeTimesheet_Daily_DataItem) ? get_class($timesheetTypeTimesheet_Daily_DataItem) : sprintf('%s(%s)', gettype($timesheetTypeTimesheet_Daily_DataItem), var_export($timesheetTypeTimesheet_Daily_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Timesheet_Daily_Data property can only contain items of type \StructType\Timesheet_Daily_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Timesheet_Daily_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Timesheet_Daily_WWS_DataType[] $timesheet_Daily_Data
     * @return \StructType\TimesheetType
     */
    public function setTimesheet_Daily_Data(array $timesheet_Daily_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($timesheet_Daily_DataArrayErrorMessage = self::validateTimesheet_Daily_DataForArrayConstraintsFromSetTimesheet_Daily_Data($timesheet_Daily_Data))) {
            throw new \InvalidArgumentException($timesheet_Daily_DataArrayErrorMessage, __LINE__);
        }
        $this->Timesheet_Daily_Data = $timesheet_Daily_Data;
        return $this;
    }
    /**
     * Add item to Timesheet_Daily_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Timesheet_Daily_WWS_DataType $item
     * @return \StructType\TimesheetType
     */
    public function addToTimesheet_Daily_Data(\StructType\Timesheet_Daily_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Timesheet_Daily_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Timesheet_Daily_Data property can only contain items of type \StructType\Timesheet_Daily_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Timesheet_Daily_Data[] = $item;
        return $this;
    }
}
