<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Line_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains the specific instance set containing the requested supplier invoice line. The type attribute is either Reference ID type or Workday ID and the ID is the value for the instance of the supplier invoice line.
 * @subpackage Structs
 */
class Supplier_Invoice_Line_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Invoice Line reference
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Invoice_LineObjectType[]
     */
    public $Supplier_Invoice_Line_Reference;
    /**
     * Constructor method for Supplier_Invoice_Line_Request_ReferencesType
     * @uses Supplier_Invoice_Line_Request_ReferencesType::setSupplier_Invoice_Line_Reference()
     * @param \StructType\Supplier_Invoice_LineObjectType[] $supplier_Invoice_Line_Reference
     */
    public function __construct(array $supplier_Invoice_Line_Reference = array())
    {
        $this
            ->setSupplier_Invoice_Line_Reference($supplier_Invoice_Line_Reference);
    }
    /**
     * Get Supplier_Invoice_Line_Reference value
     * @return \StructType\Supplier_Invoice_LineObjectType[]|null
     */
    public function getSupplier_Invoice_Line_Reference()
    {
        return $this->Supplier_Invoice_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Line_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Line_Request_ReferencesTypeSupplier_Invoice_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Line_Request_ReferencesTypeSupplier_Invoice_Line_ReferenceItem instanceof \StructType\Supplier_Invoice_LineObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Line_Request_ReferencesTypeSupplier_Invoice_Line_ReferenceItem) ? get_class($supplier_Invoice_Line_Request_ReferencesTypeSupplier_Invoice_Line_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Line_Request_ReferencesTypeSupplier_Invoice_Line_ReferenceItem), var_export($supplier_Invoice_Line_Request_ReferencesTypeSupplier_Invoice_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Line_Reference property can only contain items of type \StructType\Supplier_Invoice_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_LineObjectType[] $supplier_Invoice_Line_Reference
     * @return \StructType\Supplier_Invoice_Line_Request_ReferencesType
     */
    public function setSupplier_Invoice_Line_Reference(array $supplier_Invoice_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Line_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Line_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Line_Reference($supplier_Invoice_Line_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Line_Reference = $supplier_Invoice_Line_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_LineObjectType $item
     * @return \StructType\Supplier_Invoice_Line_Request_ReferencesType
     */
    public function addToSupplier_Invoice_Line_Reference(\StructType\Supplier_Invoice_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Line_Reference property can only contain items of type \StructType\Supplier_Invoice_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Line_Reference[] = $item;
        return $this;
    }
}
