<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Task_Resources_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for Project Task Resource Line Data Element
 * @subpackage Structs
 */
class Project_Task_Resources_DataType extends AbstractStructBase
{
    /**
     * The Project_ID
     * Meta information extracted from the WSDL
     * - documentation: Project ID Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_ID;
    /**
     * The Project_Task_Resource_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Task_Resource_Line_DataType[]
     */
    public $Project_Task_Resource_Line_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: This flag controls whether or not to replace existing Project Task Resources for the Project. When true, existing Project Task Resources are removed before the data in this web service request is processed.
     * @var bool
     */
    public $Replace_All;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * Constructor method for Project_Task_Resources_DataType
     * @uses Project_Task_Resources_DataType::setProject_ID()
     * @uses Project_Task_Resources_DataType::setProject_Task_Resource_Line_Data()
     * @uses Project_Task_Resources_DataType::setReplace_All()
     * @uses Project_Task_Resources_DataType::setAdd_Only()
     * @param string $project_ID
     * @param \StructType\Project_Task_Resource_Line_DataType[] $project_Task_Resource_Line_Data
     * @param bool $replace_All
     * @param bool $add_Only
     */
    public function __construct($project_ID = null, array $project_Task_Resource_Line_Data = array(), $replace_All = null, $add_Only = null)
    {
        $this
            ->setProject_ID($project_ID)
            ->setProject_Task_Resource_Line_Data($project_Task_Resource_Line_Data)
            ->setReplace_All($replace_All)
            ->setAdd_Only($add_Only);
    }
    /**
     * Get Project_ID value
     * @return string|null
     */
    public function getProject_ID()
    {
        return $this->Project_ID;
    }
    /**
     * Set Project_ID value
     * @param string $project_ID
     * @return \StructType\Project_Task_Resources_DataType
     */
    public function setProject_ID($project_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_ID) && !is_string($project_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_ID, true), gettype($project_ID)), __LINE__);
        }
        $this->Project_ID = $project_ID;
        return $this;
    }
    /**
     * Get Project_Task_Resource_Line_Data value
     * @return \StructType\Project_Task_Resource_Line_DataType[]|null
     */
    public function getProject_Task_Resource_Line_Data()
    {
        return $this->Project_Task_Resource_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Task_Resource_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Task_Resource_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Task_Resource_Line_DataForArrayConstraintsFromSetProject_Task_Resource_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Task_Resources_DataTypeProject_Task_Resource_Line_DataItem) {
            // validation for constraint: itemType
            if (!$project_Task_Resources_DataTypeProject_Task_Resource_Line_DataItem instanceof \StructType\Project_Task_Resource_Line_DataType) {
                $invalidValues[] = is_object($project_Task_Resources_DataTypeProject_Task_Resource_Line_DataItem) ? get_class($project_Task_Resources_DataTypeProject_Task_Resource_Line_DataItem) : sprintf('%s(%s)', gettype($project_Task_Resources_DataTypeProject_Task_Resource_Line_DataItem), var_export($project_Task_Resources_DataTypeProject_Task_Resource_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Task_Resource_Line_Data property can only contain items of type \StructType\Project_Task_Resource_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Task_Resource_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Task_Resource_Line_DataType[] $project_Task_Resource_Line_Data
     * @return \StructType\Project_Task_Resources_DataType
     */
    public function setProject_Task_Resource_Line_Data(array $project_Task_Resource_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Task_Resource_Line_DataArrayErrorMessage = self::validateProject_Task_Resource_Line_DataForArrayConstraintsFromSetProject_Task_Resource_Line_Data($project_Task_Resource_Line_Data))) {
            throw new \InvalidArgumentException($project_Task_Resource_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Task_Resource_Line_Data = $project_Task_Resource_Line_Data;
        return $this;
    }
    /**
     * Add item to Project_Task_Resource_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Task_Resource_Line_DataType $item
     * @return \StructType\Project_Task_Resources_DataType
     */
    public function addToProject_Task_Resource_Line_Data(\StructType\Project_Task_Resource_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Task_Resource_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Task_Resource_Line_Data property can only contain items of type \StructType\Project_Task_Resource_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Task_Resource_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Project_Task_Resources_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Project_Task_Resources_DataType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
}
