<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Condition_RuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each Procurement Condition Rule based on the Request References or Request Criteria.
 * @subpackage Structs
 */
class Procurement_Condition_RuleType extends AbstractStructBase
{
    /**
     * The Procurement_Condition_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Condition Rule Reference
     * - minOccurs: 0
     * @var \StructType\Condition_RuleObjectType
     */
    public $Procurement_Condition_Rule_Reference;
    /**
     * The Procurement_Condition_Rule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Condition_Rule_DataType[]
     */
    public $Procurement_Condition_Rule_Data;
    /**
     * Constructor method for Procurement_Condition_RuleType
     * @uses Procurement_Condition_RuleType::setProcurement_Condition_Rule_Reference()
     * @uses Procurement_Condition_RuleType::setProcurement_Condition_Rule_Data()
     * @param \StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference
     * @param \StructType\Procurement_Condition_Rule_DataType[] $procurement_Condition_Rule_Data
     */
    public function __construct(\StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference = null, array $procurement_Condition_Rule_Data = array())
    {
        $this
            ->setProcurement_Condition_Rule_Reference($procurement_Condition_Rule_Reference)
            ->setProcurement_Condition_Rule_Data($procurement_Condition_Rule_Data);
    }
    /**
     * Get Procurement_Condition_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getProcurement_Condition_Rule_Reference()
    {
        return $this->Procurement_Condition_Rule_Reference;
    }
    /**
     * Set Procurement_Condition_Rule_Reference value
     * @param \StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference
     * @return \StructType\Procurement_Condition_RuleType
     */
    public function setProcurement_Condition_Rule_Reference(\StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference = null)
    {
        $this->Procurement_Condition_Rule_Reference = $procurement_Condition_Rule_Reference;
        return $this;
    }
    /**
     * Get Procurement_Condition_Rule_Data value
     * @return \StructType\Procurement_Condition_Rule_DataType[]|null
     */
    public function getProcurement_Condition_Rule_Data()
    {
        return $this->Procurement_Condition_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Condition_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Condition_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Condition_Rule_DataForArrayConstraintsFromSetProcurement_Condition_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Condition_RuleTypeProcurement_Condition_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Condition_RuleTypeProcurement_Condition_Rule_DataItem instanceof \StructType\Procurement_Condition_Rule_DataType) {
                $invalidValues[] = is_object($procurement_Condition_RuleTypeProcurement_Condition_Rule_DataItem) ? get_class($procurement_Condition_RuleTypeProcurement_Condition_Rule_DataItem) : sprintf('%s(%s)', gettype($procurement_Condition_RuleTypeProcurement_Condition_Rule_DataItem), var_export($procurement_Condition_RuleTypeProcurement_Condition_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Condition_Rule_Data property can only contain items of type \StructType\Procurement_Condition_Rule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Condition_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Condition_Rule_DataType[] $procurement_Condition_Rule_Data
     * @return \StructType\Procurement_Condition_RuleType
     */
    public function setProcurement_Condition_Rule_Data(array $procurement_Condition_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Condition_Rule_DataArrayErrorMessage = self::validateProcurement_Condition_Rule_DataForArrayConstraintsFromSetProcurement_Condition_Rule_Data($procurement_Condition_Rule_Data))) {
            throw new \InvalidArgumentException($procurement_Condition_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Condition_Rule_Data = $procurement_Condition_Rule_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Condition_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Condition_Rule_DataType $item
     * @return \StructType\Procurement_Condition_RuleType
     */
    public function addToProcurement_Condition_Rule_Data(\StructType\Procurement_Condition_Rule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Condition_Rule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Condition_Rule_Data property can only contain items of type \StructType\Procurement_Condition_Rule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Condition_Rule_Data[] = $item;
        return $this;
    }
}
