<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_Amortization_Schedule_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: A list of all the schedules that were found.
 * @subpackage Structs
 */
class Prepaid_Spend_Amortization_Schedule_Response_DataType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Schedule
     * Meta information extracted from the WSDL
     * - documentation: One schedule that was found along with the installments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_ScheduleType[]
     */
    public $Prepaid_Spend_Amortization_Schedule;
    /**
     * Constructor method for Prepaid_Spend_Amortization_Schedule_Response_DataType
     * @uses Prepaid_Spend_Amortization_Schedule_Response_DataType::setPrepaid_Spend_Amortization_Schedule()
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleType[] $prepaid_Spend_Amortization_Schedule
     */
    public function __construct(array $prepaid_Spend_Amortization_Schedule = array())
    {
        $this
            ->setPrepaid_Spend_Amortization_Schedule($prepaid_Spend_Amortization_Schedule);
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule value
     * @return \StructType\Prepaid_Spend_Amortization_ScheduleType[]|null
     */
    public function getPrepaid_Spend_Amortization_Schedule()
    {
        return $this->Prepaid_Spend_Amortization_Schedule;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Spend_Amortization_Schedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Schedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Spend_Amortization_ScheduleForArrayConstraintsFromSetPrepaid_Spend_Amortization_Schedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepaid_Spend_Amortization_Schedule_Response_DataTypePrepaid_Spend_Amortization_ScheduleItem) {
            // validation for constraint: itemType
            if (!$prepaid_Spend_Amortization_Schedule_Response_DataTypePrepaid_Spend_Amortization_ScheduleItem instanceof \StructType\Prepaid_Spend_Amortization_ScheduleType) {
                $invalidValues[] = is_object($prepaid_Spend_Amortization_Schedule_Response_DataTypePrepaid_Spend_Amortization_ScheduleItem) ? get_class($prepaid_Spend_Amortization_Schedule_Response_DataTypePrepaid_Spend_Amortization_ScheduleItem) : sprintf('%s(%s)', gettype($prepaid_Spend_Amortization_Schedule_Response_DataTypePrepaid_Spend_Amortization_ScheduleItem), var_export($prepaid_Spend_Amortization_Schedule_Response_DataTypePrepaid_Spend_Amortization_ScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Spend_Amortization_Schedule property can only contain items of type \StructType\Prepaid_Spend_Amortization_ScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleType[] $prepaid_Spend_Amortization_Schedule
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_Response_DataType
     */
    public function setPrepaid_Spend_Amortization_Schedule(array $prepaid_Spend_Amortization_Schedule = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Spend_Amortization_ScheduleArrayErrorMessage = self::validatePrepaid_Spend_Amortization_ScheduleForArrayConstraintsFromSetPrepaid_Spend_Amortization_Schedule($prepaid_Spend_Amortization_Schedule))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_ScheduleArrayErrorMessage, __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Schedule = $prepaid_Spend_Amortization_Schedule;
        return $this;
    }
    /**
     * Add item to Prepaid_Spend_Amortization_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleType $item
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_Response_DataType
     */
    public function addToPrepaid_Spend_Amortization_Schedule(\StructType\Prepaid_Spend_Amortization_ScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prepaid_Spend_Amortization_ScheduleType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Spend_Amortization_Schedule property can only contain items of type \StructType\Prepaid_Spend_Amortization_ScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Schedule[] = $item;
        return $this;
    }
}
