<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Graduated_Expense_Rate_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: End of Range must be greater than the Start of Range. | Expense Rate is required for Expense Rate Table with table type Amount, Graduated Amount, or Graduated Percent | Maximum Value is required for Expense Rate Table with table type
 * Maximum or Graduated Amount | Expense Rate is not used in Expense Rate Table with table type of Maximum. | Minimum Value is not used in Expense Rate Table with table type of Amount. | Average Value is used in Expense Rate Table with table type of
 * Maximum. | Maximum Value is not used in Expense Rate Table with table type of Amount. | Currency is not used in Expense Rate Table with table type of Graduated Percent. | Element containing all Graduated Expense Rate data
 * @subpackage Structs
 */
class Graduated_Expense_Rate_DataType extends AbstractStructBase
{
    /**
     * The Minimum_Value
     * Meta information extracted from the WSDL
     * - documentation: Minimum Amount for Maximum Expense Rate Tables or Start of Range for Graduated Amount and Percent Expense Rate Tables.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Minimum_Value;
    /**
     * The Average_Value
     * Meta information extracted from the WSDL
     * - documentation: Average Amount for Maximum Expense Rate Tables.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Average_Value;
    /**
     * The Maximum_Value
     * Meta information extracted from the WSDL
     * - documentation: Maximum Amount for Maximum Expense Rate Tables or End of Range for Graduated Amount and Percent Expense Rate Tables.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Maximum_Value;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: Percentage for Percent Expense Rate Tables or Fixed Amount for Amount and Graduated Amount Expense Rate Tables.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Rate;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Currency. Sets the currency of graduated expense rate.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * Constructor method for Graduated_Expense_Rate_DataType
     * @uses Graduated_Expense_Rate_DataType::setMinimum_Value()
     * @uses Graduated_Expense_Rate_DataType::setAverage_Value()
     * @uses Graduated_Expense_Rate_DataType::setMaximum_Value()
     * @uses Graduated_Expense_Rate_DataType::setRate()
     * @uses Graduated_Expense_Rate_DataType::setCurrency_Reference()
     * @param float $minimum_Value
     * @param float $average_Value
     * @param float $maximum_Value
     * @param float $rate
     * @param \StructType\CurrencyObjectType $currency_Reference
     */
    public function __construct($minimum_Value = null, $average_Value = null, $maximum_Value = null, $rate = null, \StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this
            ->setMinimum_Value($minimum_Value)
            ->setAverage_Value($average_Value)
            ->setMaximum_Value($maximum_Value)
            ->setRate($rate)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Minimum_Value value
     * @return float|null
     */
    public function getMinimum_Value()
    {
        return $this->Minimum_Value;
    }
    /**
     * Set Minimum_Value value
     * @param float $minimum_Value
     * @return \StructType\Graduated_Expense_Rate_DataType
     */
    public function setMinimum_Value($minimum_Value = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Value) && !(is_float($minimum_Value) || is_numeric($minimum_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Value, true), gettype($minimum_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($minimum_Value) && mb_strlen(mb_substr($minimum_Value, false !== mb_strpos($minimum_Value, '.') ? mb_strpos($minimum_Value, '.') + 1 : mb_strlen($minimum_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($minimum_Value, true), mb_strlen(mb_substr($minimum_Value, mb_strpos($minimum_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($minimum_Value) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($minimum_Value, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Value))), __LINE__);
        }
        $this->Minimum_Value = $minimum_Value;
        return $this;
    }
    /**
     * Get Average_Value value
     * @return float|null
     */
    public function getAverage_Value()
    {
        return $this->Average_Value;
    }
    /**
     * Set Average_Value value
     * @param float $average_Value
     * @return \StructType\Graduated_Expense_Rate_DataType
     */
    public function setAverage_Value($average_Value = null)
    {
        // validation for constraint: float
        if (!is_null($average_Value) && !(is_float($average_Value) || is_numeric($average_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($average_Value, true), gettype($average_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($average_Value) && mb_strlen(mb_substr($average_Value, false !== mb_strpos($average_Value, '.') ? mb_strpos($average_Value, '.') + 1 : mb_strlen($average_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($average_Value, true), mb_strlen(mb_substr($average_Value, mb_strpos($average_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($average_Value) && $average_Value < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($average_Value, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($average_Value) && mb_strlen(preg_replace('/(\D)/', '', $average_Value)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($average_Value, true), mb_strlen(preg_replace('/(\D)/', '', $average_Value))), __LINE__);
        }
        $this->Average_Value = $average_Value;
        return $this;
    }
    /**
     * Get Maximum_Value value
     * @return float|null
     */
    public function getMaximum_Value()
    {
        return $this->Maximum_Value;
    }
    /**
     * Set Maximum_Value value
     * @param float $maximum_Value
     * @return \StructType\Graduated_Expense_Rate_DataType
     */
    public function setMaximum_Value($maximum_Value = null)
    {
        // validation for constraint: float
        if (!is_null($maximum_Value) && !(is_float($maximum_Value) || is_numeric($maximum_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum_Value, true), gettype($maximum_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($maximum_Value) && mb_strlen(mb_substr($maximum_Value, false !== mb_strpos($maximum_Value, '.') ? mb_strpos($maximum_Value, '.') + 1 : mb_strlen($maximum_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($maximum_Value, true), mb_strlen(mb_substr($maximum_Value, mb_strpos($maximum_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($maximum_Value) && mb_strlen(preg_replace('/(\D)/', '', $maximum_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($maximum_Value, true), mb_strlen(preg_replace('/(\D)/', '', $maximum_Value))), __LINE__);
        }
        $this->Maximum_Value = $maximum_Value;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\Graduated_Expense_Rate_DataType
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($rate) && mb_strlen(mb_substr($rate, false !== mb_strpos($rate, '.') ? mb_strpos($rate, '.') + 1 : mb_strlen($rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($rate, true), mb_strlen(mb_substr($rate, mb_strpos($rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rate) && $rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($rate) && mb_strlen(preg_replace('/(\D)/', '', $rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($rate, true), mb_strlen(preg_replace('/(\D)/', '', $rate))), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Graduated_Expense_Rate_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
}
