<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the Assets returned by the web service operation.
 * @subpackage Structs
 */
class Asset_Response_DataType extends AbstractStructBase
{
    /**
     * The Asset
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AssetType[]
     */
    public $Asset;
    /**
     * Constructor method for Asset_Response_DataType
     * @uses Asset_Response_DataType::setAsset()
     * @param \StructType\AssetType[] $asset
     */
    public function __construct(array $asset = array())
    {
        $this
            ->setAsset($asset);
    }
    /**
     * Get Asset value
     * @return \StructType\AssetType[]|null
     */
    public function getAsset()
    {
        return $this->Asset;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssetForArrayConstraintsFromSetAsset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Response_DataTypeAssetItem) {
            // validation for constraint: itemType
            if (!$asset_Response_DataTypeAssetItem instanceof \StructType\AssetType) {
                $invalidValues[] = is_object($asset_Response_DataTypeAssetItem) ? get_class($asset_Response_DataTypeAssetItem) : sprintf('%s(%s)', gettype($asset_Response_DataTypeAssetItem), var_export($asset_Response_DataTypeAssetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset property can only contain items of type \StructType\AssetType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset value
     * @throws \InvalidArgumentException
     * @param \StructType\AssetType[] $asset
     * @return \StructType\Asset_Response_DataType
     */
    public function setAsset(array $asset = array())
    {
        // validation for constraint: array
        if ('' !== ($assetArrayErrorMessage = self::validateAssetForArrayConstraintsFromSetAsset($asset))) {
            throw new \InvalidArgumentException($assetArrayErrorMessage, __LINE__);
        }
        $this->Asset = $asset;
        return $this;
    }
    /**
     * Add item to Asset value
     * @throws \InvalidArgumentException
     * @param \StructType\AssetType $item
     * @return \StructType\Asset_Response_DataType
     */
    public function addToAsset(\StructType\AssetType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssetType) {
            throw new \InvalidArgumentException(sprintf('The Asset property can only contain items of type \StructType\AssetType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset[] = $item;
        return $this;
    }
}
