<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Category_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Category Instance and Data
 * @subpackage Structs
 */
class Supplier_Category_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Category
     * Meta information extracted from the WSDL
     * - documentation: Supplier Category
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryType[]
     */
    public $Supplier_Category;
    /**
     * Constructor method for Supplier_Category_Response_DataType
     * @uses Supplier_Category_Response_DataType::setSupplier_Category()
     * @param \StructType\Supplier_CategoryType[] $supplier_Category
     */
    public function __construct(array $supplier_Category = array())
    {
        $this
            ->setSupplier_Category($supplier_Category);
    }
    /**
     * Get Supplier_Category value
     * @return \StructType\Supplier_CategoryType[]|null
     */
    public function getSupplier_Category()
    {
        return $this->Supplier_Category;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Category method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Category method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_CategoryForArrayConstraintsFromSetSupplier_Category(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Category_Response_DataTypeSupplier_CategoryItem) {
            // validation for constraint: itemType
            if (!$supplier_Category_Response_DataTypeSupplier_CategoryItem instanceof \StructType\Supplier_CategoryType) {
                $invalidValues[] = is_object($supplier_Category_Response_DataTypeSupplier_CategoryItem) ? get_class($supplier_Category_Response_DataTypeSupplier_CategoryItem) : sprintf('%s(%s)', gettype($supplier_Category_Response_DataTypeSupplier_CategoryItem), var_export($supplier_Category_Response_DataTypeSupplier_CategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Category property can only contain items of type \StructType\Supplier_CategoryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Category value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryType[] $supplier_Category
     * @return \StructType\Supplier_Category_Response_DataType
     */
    public function setSupplier_Category(array $supplier_Category = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_CategoryArrayErrorMessage = self::validateSupplier_CategoryForArrayConstraintsFromSetSupplier_Category($supplier_Category))) {
            throw new \InvalidArgumentException($supplier_CategoryArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Category = $supplier_Category;
        return $this;
    }
    /**
     * Add item to Supplier_Category value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryType $item
     * @return \StructType\Supplier_Category_Response_DataType
     */
    public function addToSupplier_Category(\StructType\Supplier_CategoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CategoryType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Category property can only contain items of type \StructType\Supplier_CategoryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Category[] = $item;
        return $this;
    }
}
