<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Netting_Transaction_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Netting Transaction Business Processing Options and all Netting Transaction data required to create a complete Netting Transaction
 * @subpackage Structs
 */
class Submit_Netting_Transaction_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Netting_Transaction_Data
     * @var \StructType\Netting_Transaction_DataType
     */
    public $Netting_Transaction_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Netting_Transaction_RequestType
     * @uses Submit_Netting_Transaction_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Netting_Transaction_RequestType::setNetting_Transaction_Data()
     * @uses Submit_Netting_Transaction_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Netting_Transaction_DataType $netting_Transaction_Data
     * @param string $version
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Netting_Transaction_DataType $netting_Transaction_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setNetting_Transaction_Data($netting_Transaction_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Netting_Transaction_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Netting_Transaction_Data value
     * @return \StructType\Netting_Transaction_DataType|null
     */
    public function getNetting_Transaction_Data()
    {
        return $this->Netting_Transaction_Data;
    }
    /**
     * Set Netting_Transaction_Data value
     * @param \StructType\Netting_Transaction_DataType $netting_Transaction_Data
     * @return \StructType\Submit_Netting_Transaction_RequestType
     */
    public function setNetting_Transaction_Data(\StructType\Netting_Transaction_DataType $netting_Transaction_Data = null)
    {
        $this->Netting_Transaction_Data = $netting_Transaction_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Netting_Transaction_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
