<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Return_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Return Information
 * @subpackage Structs
 */
class Return_Response_DataType extends AbstractStructBase
{
    /**
     * The Return
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Return_to_SupplierType[]
     */
    public $Return;
    /**
     * Constructor method for Return_Response_DataType
     * @uses Return_Response_DataType::setReturn()
     * @param \StructType\Return_to_SupplierType[] $return
     */
    public function __construct(array $return = array())
    {
        $this
            ->setReturn($return);
    }
    /**
     * Get Return value
     * @return \StructType\Return_to_SupplierType[]|null
     */
    public function getReturn()
    {
        return $this->Return;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnForArrayConstraintsFromSetReturn(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Response_DataTypeReturnItem) {
            // validation for constraint: itemType
            if (!$return_Response_DataTypeReturnItem instanceof \StructType\Return_to_SupplierType) {
                $invalidValues[] = is_object($return_Response_DataTypeReturnItem) ? get_class($return_Response_DataTypeReturnItem) : sprintf('%s(%s)', gettype($return_Response_DataTypeReturnItem), var_export($return_Response_DataTypeReturnItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return property can only contain items of type \StructType\Return_to_SupplierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_SupplierType[] $return
     * @return \StructType\Return_Response_DataType
     */
    public function setReturn(array $return = array())
    {
        // validation for constraint: array
        if ('' !== ($returnArrayErrorMessage = self::validateReturnForArrayConstraintsFromSetReturn($return))) {
            throw new \InvalidArgumentException($returnArrayErrorMessage, __LINE__);
        }
        $this->Return = $return;
        return $this;
    }
    /**
     * Add item to Return value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_SupplierType $item
     * @return \StructType\Return_Response_DataType
     */
    public function addToReturn(\StructType\Return_to_SupplierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Return_to_SupplierType) {
            throw new \InvalidArgumentException(sprintf('The Return property can only contain items of type \StructType\Return_to_SupplierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return[] = $item;
        return $this;
    }
}
