<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Budget_Template_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Budget Template Line Data Details
 * @subpackage Structs
 */
class Project_Budget_Template_Line_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Project Budget Template Line Reference ID. This is the Project Budget Template Line unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Ledger_Account_Summary_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Ledger Account/Summary to apply to this Project Budget Template Line
     * - minOccurs: 0
     * @var \StructType\Financial_Report_GroupObjectType
     */
    public $Ledger_Account_Summary_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktag Budget Dimensions to apply to this Project Budget Template Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Delete is set to true, Replace All must be set to false. | Valid ID must be provided when Delete flag is set. | Selecting this will cause the referenced Project Budget Template Line to be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Project_Budget_Template_Line_DataType
     * @uses Project_Budget_Template_Line_DataType::setID()
     * @uses Project_Budget_Template_Line_DataType::setLedger_Account_Summary_Reference()
     * @uses Project_Budget_Template_Line_DataType::setWorktags_Reference()
     * @uses Project_Budget_Template_Line_DataType::setDelete()
     * @param string $iD
     * @param \StructType\Financial_Report_GroupObjectType $ledger_Account_Summary_Reference
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType[] $worktags_Reference
     * @param bool $delete
     */
    public function __construct($iD = null, \StructType\Financial_Report_GroupObjectType $ledger_Account_Summary_Reference = null, array $worktags_Reference = array(), $delete = null)
    {
        $this
            ->setID($iD)
            ->setLedger_Account_Summary_Reference($ledger_Account_Summary_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setDelete($delete);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Project_Budget_Template_Line_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Ledger_Account_Summary_Reference value
     * @return \StructType\Financial_Report_GroupObjectType|null
     */
    public function getLedger_Account_Summary_Reference()
    {
        return $this->Ledger_Account_Summary_Reference;
    }
    /**
     * Set Ledger_Account_Summary_Reference value
     * @param \StructType\Financial_Report_GroupObjectType $ledger_Account_Summary_Reference
     * @return \StructType\Project_Budget_Template_Line_DataType
     */
    public function setLedger_Account_Summary_Reference(\StructType\Financial_Report_GroupObjectType $ledger_Account_Summary_Reference = null)
    {
        $this->Ledger_Account_Summary_Reference = $ledger_Account_Summary_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Budget_Template_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Budget_Template_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType) {
                $invalidValues[] = is_object($project_Budget_Template_Line_DataTypeWorktags_ReferenceItem) ? get_class($project_Budget_Template_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($project_Budget_Template_Line_DataTypeWorktags_ReferenceItem), var_export($project_Budget_Template_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType[] $worktags_Reference
     * @return \StructType\Project_Budget_Template_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $item
     * @return \StructType\Project_Budget_Template_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Budget_Template_Line_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
