<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Lines_For_Amortization_Schedule_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Prepaid Purchase Order Lines for Amortization Schedule
 * @subpackage Structs
 */
class Purchase_Order_Lines_For_Amortization_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Number
     * Meta information extracted from the WSDL
     * - documentation: The line number of the Purchase Order. | the Line Number of the Prepaid Purchase Order Line to include in the schedule
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Purchase_Order_Line_Number;
    /**
     * Constructor method for Purchase_Order_Lines_For_Amortization_Schedule_DataType
     * @uses Purchase_Order_Lines_For_Amortization_Schedule_DataType::setPurchase_Order_Line_Number()
     * @param float $purchase_Order_Line_Number
     */
    public function __construct($purchase_Order_Line_Number = null)
    {
        $this
            ->setPurchase_Order_Line_Number($purchase_Order_Line_Number);
    }
    /**
     * Get Purchase_Order_Line_Number value
     * @return float|null
     */
    public function getPurchase_Order_Line_Number()
    {
        return $this->Purchase_Order_Line_Number;
    }
    /**
     * Set Purchase_Order_Line_Number value
     * @param float $purchase_Order_Line_Number
     * @return \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType
     */
    public function setPurchase_Order_Line_Number($purchase_Order_Line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($purchase_Order_Line_Number) && !(is_float($purchase_Order_Line_Number) || is_numeric($purchase_Order_Line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchase_Order_Line_Number, true), gettype($purchase_Order_Line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($purchase_Order_Line_Number) && mb_strlen(mb_substr($purchase_Order_Line_Number, false !== mb_strpos($purchase_Order_Line_Number, '.') ? mb_strpos($purchase_Order_Line_Number, '.') + 1 : mb_strlen($purchase_Order_Line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($purchase_Order_Line_Number, true), mb_strlen(mb_substr($purchase_Order_Line_Number, mb_strpos($purchase_Order_Line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($purchase_Order_Line_Number) && $purchase_Order_Line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($purchase_Order_Line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($purchase_Order_Line_Number) && mb_strlen(preg_replace('/(\D)/', '', $purchase_Order_Line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($purchase_Order_Line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $purchase_Order_Line_Number))), __LINE__);
        }
        $this->Purchase_Order_Line_Number = $purchase_Order_Line_Number;
        return $this;
    }
}
