<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Budget_TemplateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Budget Template Details
 * @subpackage Structs
 */
class Project_Budget_TemplateType extends AbstractStructBase
{
    /**
     * The Project_Budget_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Project Budget Template being processed
     * - minOccurs: 0
     * @var \StructType\Project_Budget_TemplateObjectType
     */
    public $Project_Budget_Template_Reference;
    /**
     * The Project_Budget_Template_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Budget_Template_DataType[]
     */
    public $Project_Budget_Template_Data;
    /**
     * Constructor method for Project_Budget_TemplateType
     * @uses Project_Budget_TemplateType::setProject_Budget_Template_Reference()
     * @uses Project_Budget_TemplateType::setProject_Budget_Template_Data()
     * @param \StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference
     * @param \StructType\Project_Budget_Template_DataType[] $project_Budget_Template_Data
     */
    public function __construct(\StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference = null, array $project_Budget_Template_Data = array())
    {
        $this
            ->setProject_Budget_Template_Reference($project_Budget_Template_Reference)
            ->setProject_Budget_Template_Data($project_Budget_Template_Data);
    }
    /**
     * Get Project_Budget_Template_Reference value
     * @return \StructType\Project_Budget_TemplateObjectType|null
     */
    public function getProject_Budget_Template_Reference()
    {
        return $this->Project_Budget_Template_Reference;
    }
    /**
     * Set Project_Budget_Template_Reference value
     * @param \StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference
     * @return \StructType\Project_Budget_TemplateType
     */
    public function setProject_Budget_Template_Reference(\StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference = null)
    {
        $this->Project_Budget_Template_Reference = $project_Budget_Template_Reference;
        return $this;
    }
    /**
     * Get Project_Budget_Template_Data value
     * @return \StructType\Project_Budget_Template_DataType[]|null
     */
    public function getProject_Budget_Template_Data()
    {
        return $this->Project_Budget_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Budget_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Budget_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Budget_Template_DataForArrayConstraintsFromSetProject_Budget_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Budget_TemplateTypeProject_Budget_Template_DataItem) {
            // validation for constraint: itemType
            if (!$project_Budget_TemplateTypeProject_Budget_Template_DataItem instanceof \StructType\Project_Budget_Template_DataType) {
                $invalidValues[] = is_object($project_Budget_TemplateTypeProject_Budget_Template_DataItem) ? get_class($project_Budget_TemplateTypeProject_Budget_Template_DataItem) : sprintf('%s(%s)', gettype($project_Budget_TemplateTypeProject_Budget_Template_DataItem), var_export($project_Budget_TemplateTypeProject_Budget_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Budget_Template_Data property can only contain items of type \StructType\Project_Budget_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Budget_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Budget_Template_DataType[] $project_Budget_Template_Data
     * @return \StructType\Project_Budget_TemplateType
     */
    public function setProject_Budget_Template_Data(array $project_Budget_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Budget_Template_DataArrayErrorMessage = self::validateProject_Budget_Template_DataForArrayConstraintsFromSetProject_Budget_Template_Data($project_Budget_Template_Data))) {
            throw new \InvalidArgumentException($project_Budget_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Budget_Template_Data = $project_Budget_Template_Data;
        return $this;
    }
    /**
     * Add item to Project_Budget_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Budget_Template_DataType $item
     * @return \StructType\Project_Budget_TemplateType
     */
    public function addToProject_Budget_Template_Data(\StructType\Project_Budget_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Budget_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Budget_Template_Data property can only contain items of type \StructType\Project_Budget_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Budget_Template_Data[] = $item;
        return $this;
    }
}
