<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Impair_Asset_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data used to process the asset impairment.
 * @subpackage Structs
 */
class Impair_Asset_WWS_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: The asset is part of a lease contract. You can't impair leased assets. | A reference to the asset that will be impaired.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The transaction effective date for the asset impairment. This date cannot be before the acquisition date, in service date, the last cost adjustment or impairment date for the asset. The ledger period status must be valid for this
     * date.
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The New_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: Workday calculates the impairment amount as Current Market Value – New Market Value. For a negative cost asset, enter a negative amount for the New Market Value that is greater than the Current Market Value and the Residual Value.
     * For a positive cost asset, enter a positive amount for the New Market Value that is less than the Current Market Value and the Residual Value. | The new market value entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $New_Market_Value;
    /**
     * The Impairment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Impairment Reason for this activity.
     * @var \StructType\Asset_Impairment_ReasonObjectType
     */
    public $Impairment_Reason_Reference;
    /**
     * The Restricted_to_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to asset books that are used by the asset. Enter asset books if you want to restrict the impairment to specific books. To enact this lifecycle event for all asset books, leave this field blank.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restricted_to_Books_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: An optional comment text to include with the asset impairment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Impair_Asset_WWS_DataType
     * @uses Impair_Asset_WWS_DataType::setAsset_Reference()
     * @uses Impair_Asset_WWS_DataType::setTransaction_Effective_Date()
     * @uses Impair_Asset_WWS_DataType::setNew_Market_Value()
     * @uses Impair_Asset_WWS_DataType::setImpairment_Reason_Reference()
     * @uses Impair_Asset_WWS_DataType::setRestricted_to_Books_Reference()
     * @uses Impair_Asset_WWS_DataType::setComment()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $transaction_Effective_Date
     * @param float $new_Market_Value
     * @param \StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @param string $comment
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $transaction_Effective_Date = null, $new_Market_Value = null, \StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference = null, array $restricted_to_Books_Reference = array(), $comment = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setNew_Market_Value($new_Market_Value)
            ->setImpairment_Reason_Reference($impairment_Reason_Reference)
            ->setRestricted_to_Books_Reference($restricted_to_Books_Reference)
            ->setComment($comment);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get New_Market_Value value
     * @return float|null
     */
    public function getNew_Market_Value()
    {
        return $this->New_Market_Value;
    }
    /**
     * Set New_Market_Value value
     * @param float $new_Market_Value
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function setNew_Market_Value($new_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($new_Market_Value) && !(is_float($new_Market_Value) || is_numeric($new_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($new_Market_Value, true), gettype($new_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($new_Market_Value) && mb_strlen(mb_substr($new_Market_Value, false !== mb_strpos($new_Market_Value, '.') ? mb_strpos($new_Market_Value, '.') + 1 : mb_strlen($new_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($new_Market_Value, true), mb_strlen(mb_substr($new_Market_Value, mb_strpos($new_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($new_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $new_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($new_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $new_Market_Value))), __LINE__);
        }
        $this->New_Market_Value = $new_Market_Value;
        return $this;
    }
    /**
     * Get Impairment_Reason_Reference value
     * @return \StructType\Asset_Impairment_ReasonObjectType|null
     */
    public function getImpairment_Reason_Reference()
    {
        return $this->Impairment_Reason_Reference;
    }
    /**
     * Set Impairment_Reason_Reference value
     * @param \StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function setImpairment_Reason_Reference(\StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference = null)
    {
        $this->Impairment_Reason_Reference = $impairment_Reason_Reference;
        return $this;
    }
    /**
     * Get Restricted_to_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestricted_to_Books_Reference()
    {
        return $this->Restricted_to_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $impair_Asset_WWS_DataTypeRestricted_to_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$impair_Asset_WWS_DataTypeRestricted_to_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($impair_Asset_WWS_DataTypeRestricted_to_Books_ReferenceItem) ? get_class($impair_Asset_WWS_DataTypeRestricted_to_Books_ReferenceItem) : sprintf('%s(%s)', gettype($impair_Asset_WWS_DataTypeRestricted_to_Books_ReferenceItem), var_export($impair_Asset_WWS_DataTypeRestricted_to_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function setRestricted_to_Books_Reference(array $restricted_to_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Books_ReferenceArrayErrorMessage = self::validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference($restricted_to_Books_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Books_Reference = $restricted_to_Books_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function addToRestricted_to_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Books_Reference[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Impair_Asset_WWS_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
