<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Pricing_Rate_SheetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains transfer pricing rate sheet instance and data based on the Request References or Request Criteria. The data returned is the current information as of the dates in the response filter, and does not include all historical
 * information about the transfer pricing rate sheet.
 * @subpackage Structs
 */
class Transfer_Pricing_Rate_SheetType extends AbstractStructBase
{
    /**
     * The Transfer_Pricing_Rate_Sheet_Reference
     * Meta information extracted from the WSDL
     * - documentation: Represents a unique instance of transfer pricing rate sheet.
     * - minOccurs: 0
     * @var \StructType\Transfer_Pricing_Rate_SheetObjectType
     */
    public $Transfer_Pricing_Rate_Sheet_Reference;
    /**
     * The Transfer_Pricing_Rate_Sheet_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains transfer pricing rate sheet data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transfer_Pricing_Rate_Sheet_DataType[]
     */
    public $Transfer_Pricing_Rate_Sheet_Data;
    /**
     * Constructor method for Transfer_Pricing_Rate_SheetType
     * @uses Transfer_Pricing_Rate_SheetType::setTransfer_Pricing_Rate_Sheet_Reference()
     * @uses Transfer_Pricing_Rate_SheetType::setTransfer_Pricing_Rate_Sheet_Data()
     * @param \StructType\Transfer_Pricing_Rate_SheetObjectType $transfer_Pricing_Rate_Sheet_Reference
     * @param \StructType\Transfer_Pricing_Rate_Sheet_DataType[] $transfer_Pricing_Rate_Sheet_Data
     */
    public function __construct(\StructType\Transfer_Pricing_Rate_SheetObjectType $transfer_Pricing_Rate_Sheet_Reference = null, array $transfer_Pricing_Rate_Sheet_Data = array())
    {
        $this
            ->setTransfer_Pricing_Rate_Sheet_Reference($transfer_Pricing_Rate_Sheet_Reference)
            ->setTransfer_Pricing_Rate_Sheet_Data($transfer_Pricing_Rate_Sheet_Data);
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Reference value
     * @return \StructType\Transfer_Pricing_Rate_SheetObjectType|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Reference()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Reference;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Reference value
     * @param \StructType\Transfer_Pricing_Rate_SheetObjectType $transfer_Pricing_Rate_Sheet_Reference
     * @return \StructType\Transfer_Pricing_Rate_SheetType
     */
    public function setTransfer_Pricing_Rate_Sheet_Reference(\StructType\Transfer_Pricing_Rate_SheetObjectType $transfer_Pricing_Rate_Sheet_Reference = null)
    {
        $this->Transfer_Pricing_Rate_Sheet_Reference = $transfer_Pricing_Rate_Sheet_Reference;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Data value
     * @return \StructType\Transfer_Pricing_Rate_Sheet_DataType[]|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Data()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTransfer_Pricing_Rate_Sheet_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransfer_Pricing_Rate_Sheet_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransfer_Pricing_Rate_Sheet_DataForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transfer_Pricing_Rate_SheetTypeTransfer_Pricing_Rate_Sheet_DataItem) {
            // validation for constraint: itemType
            if (!$transfer_Pricing_Rate_SheetTypeTransfer_Pricing_Rate_Sheet_DataItem instanceof \StructType\Transfer_Pricing_Rate_Sheet_DataType) {
                $invalidValues[] = is_object($transfer_Pricing_Rate_SheetTypeTransfer_Pricing_Rate_Sheet_DataItem) ? get_class($transfer_Pricing_Rate_SheetTypeTransfer_Pricing_Rate_Sheet_DataItem) : sprintf('%s(%s)', gettype($transfer_Pricing_Rate_SheetTypeTransfer_Pricing_Rate_Sheet_DataItem), var_export($transfer_Pricing_Rate_SheetTypeTransfer_Pricing_Rate_Sheet_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transfer_Pricing_Rate_Sheet_Data property can only contain items of type \StructType\Transfer_Pricing_Rate_Sheet_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_Sheet_DataType[] $transfer_Pricing_Rate_Sheet_Data
     * @return \StructType\Transfer_Pricing_Rate_SheetType
     */
    public function setTransfer_Pricing_Rate_Sheet_Data(array $transfer_Pricing_Rate_Sheet_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($transfer_Pricing_Rate_Sheet_DataArrayErrorMessage = self::validateTransfer_Pricing_Rate_Sheet_DataForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Data($transfer_Pricing_Rate_Sheet_Data))) {
            throw new \InvalidArgumentException($transfer_Pricing_Rate_Sheet_DataArrayErrorMessage, __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Data = $transfer_Pricing_Rate_Sheet_Data;
        return $this;
    }
    /**
     * Add item to Transfer_Pricing_Rate_Sheet_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_Sheet_DataType $item
     * @return \StructType\Transfer_Pricing_Rate_SheetType
     */
    public function addToTransfer_Pricing_Rate_Sheet_Data(\StructType\Transfer_Pricing_Rate_Sheet_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transfer_Pricing_Rate_Sheet_DataType) {
            throw new \InvalidArgumentException(sprintf('The Transfer_Pricing_Rate_Sheet_Data property can only contain items of type \StructType\Transfer_Pricing_Rate_Sheet_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Data[] = $item;
        return $this;
    }
}
