<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Return to Supplier Line Inventory Location Quantity Details
 * @subpackage Structs
 */
class Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType extends AbstractStructBase
{
    /**
     * The Stocking_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Stocking Location
     * @var \StructType\Inventory_Location_EnabledObjectType
     */
    public $Stocking_Location_Reference;
    /**
     * The Stocking_UOM_Reference
     * Meta information extracted from the WSDL
     * - documentation: Stocking Unit of Measure
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Stocking_UOM_Reference;
    /**
     * The Item_Lot_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Lot
     * - minOccurs: 0
     * @var \StructType\Item_LotObjectType
     */
    public $Item_Lot_Reference;
    /**
     * The Quantity_to_Return
     * Meta information extracted from the WSDL
     * - documentation: Quantity to Return
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity_to_Return;
    /**
     * The Item_Serial_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Serial
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_SerialObjectType[]
     */
    public $Item_Serial_Reference;
    /**
     * Constructor method for
     * Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     * @uses Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType::setStocking_Location_Reference()
     * @uses Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType::setStocking_UOM_Reference()
     * @uses Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType::setItem_Lot_Reference()
     * @uses Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType::setQuantity_to_Return()
     * @uses Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType::setItem_Serial_Reference()
     * @param \StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference
     * @param \StructType\Unit_of_MeasureObjectType $stocking_UOM_Reference
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @param float $quantity_to_Return
     * @param \StructType\Item_SerialObjectType[] $item_Serial_Reference
     */
    public function __construct(\StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference = null, \StructType\Unit_of_MeasureObjectType $stocking_UOM_Reference = null, \StructType\Item_LotObjectType $item_Lot_Reference = null, $quantity_to_Return = null, array $item_Serial_Reference = array())
    {
        $this
            ->setStocking_Location_Reference($stocking_Location_Reference)
            ->setStocking_UOM_Reference($stocking_UOM_Reference)
            ->setItem_Lot_Reference($item_Lot_Reference)
            ->setQuantity_to_Return($quantity_to_Return)
            ->setItem_Serial_Reference($item_Serial_Reference);
    }
    /**
     * Get Stocking_Location_Reference value
     * @return \StructType\Inventory_Location_EnabledObjectType|null
     */
    public function getStocking_Location_Reference()
    {
        return $this->Stocking_Location_Reference;
    }
    /**
     * Set Stocking_Location_Reference value
     * @param \StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     */
    public function setStocking_Location_Reference(\StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference = null)
    {
        $this->Stocking_Location_Reference = $stocking_Location_Reference;
        return $this;
    }
    /**
     * Get Stocking_UOM_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getStocking_UOM_Reference()
    {
        return $this->Stocking_UOM_Reference;
    }
    /**
     * Set Stocking_UOM_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $stocking_UOM_Reference
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     */
    public function setStocking_UOM_Reference(\StructType\Unit_of_MeasureObjectType $stocking_UOM_Reference = null)
    {
        $this->Stocking_UOM_Reference = $stocking_UOM_Reference;
        return $this;
    }
    /**
     * Get Item_Lot_Reference value
     * @return \StructType\Item_LotObjectType|null
     */
    public function getItem_Lot_Reference()
    {
        return $this->Item_Lot_Reference;
    }
    /**
     * Set Item_Lot_Reference value
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     */
    public function setItem_Lot_Reference(\StructType\Item_LotObjectType $item_Lot_Reference = null)
    {
        $this->Item_Lot_Reference = $item_Lot_Reference;
        return $this;
    }
    /**
     * Get Quantity_to_Return value
     * @return float|null
     */
    public function getQuantity_to_Return()
    {
        return $this->Quantity_to_Return;
    }
    /**
     * Set Quantity_to_Return value
     * @param float $quantity_to_Return
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     */
    public function setQuantity_to_Return($quantity_to_Return = null)
    {
        // validation for constraint: float
        if (!is_null($quantity_to_Return) && !(is_float($quantity_to_Return) || is_numeric($quantity_to_Return))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity_to_Return, true), gettype($quantity_to_Return)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity_to_Return) && mb_strlen(mb_substr($quantity_to_Return, false !== mb_strpos($quantity_to_Return, '.') ? mb_strpos($quantity_to_Return, '.') + 1 : mb_strlen($quantity_to_Return))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity_to_Return, true), mb_strlen(mb_substr($quantity_to_Return, mb_strpos($quantity_to_Return, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($quantity_to_Return) && $quantity_to_Return < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($quantity_to_Return, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity_to_Return) && mb_strlen(preg_replace('/(\D)/', '', $quantity_to_Return)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity_to_Return, true), mb_strlen(preg_replace('/(\D)/', '', $quantity_to_Return))), __LINE__);
        }
        $this->Quantity_to_Return = $quantity_to_Return;
        return $this;
    }
    /**
     * Get Item_Serial_Reference value
     * @return \StructType\Item_SerialObjectType[]|null
     */
    public function getItem_Serial_Reference()
    {
        return $this->Item_Serial_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Serial_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Serial_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Serial_ReferenceForArrayConstraintsFromSetItem_Serial_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataTypeItem_Serial_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataTypeItem_Serial_ReferenceItem instanceof \StructType\Item_SerialObjectType) {
                $invalidValues[] = is_object($return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataTypeItem_Serial_ReferenceItem) ? get_class($return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataTypeItem_Serial_ReferenceItem) : sprintf('%s(%s)', gettype($return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataTypeItem_Serial_ReferenceItem), var_export($return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataTypeItem_Serial_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Serial_Reference property can only contain items of type \StructType\Item_SerialObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Serial_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_SerialObjectType[] $item_Serial_Reference
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     */
    public function setItem_Serial_Reference(array $item_Serial_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Serial_ReferenceArrayErrorMessage = self::validateItem_Serial_ReferenceForArrayConstraintsFromSetItem_Serial_Reference($item_Serial_Reference))) {
            throw new \InvalidArgumentException($item_Serial_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Serial_Reference = $item_Serial_Reference;
        return $this;
    }
    /**
     * Add item to Item_Serial_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_SerialObjectType $item
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType
     */
    public function addToItem_Serial_Reference(\StructType\Item_SerialObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_SerialObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Serial_Reference property can only contain items of type \StructType\Item_SerialObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Serial_Reference[] = $item;
        return $this;
    }
}
