<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Forecast_Configuration_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Forecast Configuration Data
 * @subpackage Structs
 */
class Resource_Forecast_Configuration_DataType extends AbstractStructBase
{
    /**
     * The Project_Forecast_Level
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Level Project.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Project_Forecast_Level;
    /**
     * The Task_Forecast_Level
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Level Task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Task_Forecast_Level;
    /**
     * The Forecast_Frequency_Month
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Frequency Month.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Forecast_Frequency_Month;
    /**
     * The Forecast_Frequency_Day
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Frequency Day.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Forecast_Frequency_Day;
    /**
     * The Forecast_Frequency_Week
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Frequency Week.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Forecast_Frequency_Week;
    /**
     * The Percent_Allocation_Forecast_Source
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Source Percent Allocation
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Percent_Allocation_Forecast_Source;
    /**
     * The Estimated_hours_Forecast_Source
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Source Estimated hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Estimated_hours_Forecast_Source;
    /**
     * The Forecast_Hours_Whole
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Whole Number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Forecast_Hours_Whole;
    /**
     * The Forecast_Hours_Decimal
     * Meta information extracted from the WSDL
     * - documentation: Boolean representing Forecast Decimal.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Forecast_Hours_Decimal;
    /**
     * Constructor method for Resource_Forecast_Configuration_DataType
     * @uses Resource_Forecast_Configuration_DataType::setProject_Forecast_Level()
     * @uses Resource_Forecast_Configuration_DataType::setTask_Forecast_Level()
     * @uses Resource_Forecast_Configuration_DataType::setForecast_Frequency_Month()
     * @uses Resource_Forecast_Configuration_DataType::setForecast_Frequency_Day()
     * @uses Resource_Forecast_Configuration_DataType::setForecast_Frequency_Week()
     * @uses Resource_Forecast_Configuration_DataType::setPercent_Allocation_Forecast_Source()
     * @uses Resource_Forecast_Configuration_DataType::setEstimated_hours_Forecast_Source()
     * @uses Resource_Forecast_Configuration_DataType::setForecast_Hours_Whole()
     * @uses Resource_Forecast_Configuration_DataType::setForecast_Hours_Decimal()
     * @param bool $project_Forecast_Level
     * @param bool $task_Forecast_Level
     * @param bool $forecast_Frequency_Month
     * @param bool $forecast_Frequency_Day
     * @param bool $forecast_Frequency_Week
     * @param bool $percent_Allocation_Forecast_Source
     * @param bool $estimated_hours_Forecast_Source
     * @param bool $forecast_Hours_Whole
     * @param bool $forecast_Hours_Decimal
     */
    public function __construct($project_Forecast_Level = null, $task_Forecast_Level = null, $forecast_Frequency_Month = null, $forecast_Frequency_Day = null, $forecast_Frequency_Week = null, $percent_Allocation_Forecast_Source = null, $estimated_hours_Forecast_Source = null, $forecast_Hours_Whole = null, $forecast_Hours_Decimal = null)
    {
        $this
            ->setProject_Forecast_Level($project_Forecast_Level)
            ->setTask_Forecast_Level($task_Forecast_Level)
            ->setForecast_Frequency_Month($forecast_Frequency_Month)
            ->setForecast_Frequency_Day($forecast_Frequency_Day)
            ->setForecast_Frequency_Week($forecast_Frequency_Week)
            ->setPercent_Allocation_Forecast_Source($percent_Allocation_Forecast_Source)
            ->setEstimated_hours_Forecast_Source($estimated_hours_Forecast_Source)
            ->setForecast_Hours_Whole($forecast_Hours_Whole)
            ->setForecast_Hours_Decimal($forecast_Hours_Decimal);
    }
    /**
     * Get Project_Forecast_Level value
     * @return bool|null
     */
    public function getProject_Forecast_Level()
    {
        return $this->Project_Forecast_Level;
    }
    /**
     * Set Project_Forecast_Level value
     * @param bool $project_Forecast_Level
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setProject_Forecast_Level($project_Forecast_Level = null)
    {
        // validation for constraint: boolean
        if (!is_null($project_Forecast_Level) && !is_bool($project_Forecast_Level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($project_Forecast_Level, true), gettype($project_Forecast_Level)), __LINE__);
        }
        $this->Project_Forecast_Level = $project_Forecast_Level;
        return $this;
    }
    /**
     * Get Task_Forecast_Level value
     * @return bool|null
     */
    public function getTask_Forecast_Level()
    {
        return $this->Task_Forecast_Level;
    }
    /**
     * Set Task_Forecast_Level value
     * @param bool $task_Forecast_Level
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setTask_Forecast_Level($task_Forecast_Level = null)
    {
        // validation for constraint: boolean
        if (!is_null($task_Forecast_Level) && !is_bool($task_Forecast_Level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($task_Forecast_Level, true), gettype($task_Forecast_Level)), __LINE__);
        }
        $this->Task_Forecast_Level = $task_Forecast_Level;
        return $this;
    }
    /**
     * Get Forecast_Frequency_Month value
     * @return bool|null
     */
    public function getForecast_Frequency_Month()
    {
        return $this->Forecast_Frequency_Month;
    }
    /**
     * Set Forecast_Frequency_Month value
     * @param bool $forecast_Frequency_Month
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setForecast_Frequency_Month($forecast_Frequency_Month = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast_Frequency_Month) && !is_bool($forecast_Frequency_Month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forecast_Frequency_Month, true), gettype($forecast_Frequency_Month)), __LINE__);
        }
        $this->Forecast_Frequency_Month = $forecast_Frequency_Month;
        return $this;
    }
    /**
     * Get Forecast_Frequency_Day value
     * @return bool|null
     */
    public function getForecast_Frequency_Day()
    {
        return $this->Forecast_Frequency_Day;
    }
    /**
     * Set Forecast_Frequency_Day value
     * @param bool $forecast_Frequency_Day
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setForecast_Frequency_Day($forecast_Frequency_Day = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast_Frequency_Day) && !is_bool($forecast_Frequency_Day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forecast_Frequency_Day, true), gettype($forecast_Frequency_Day)), __LINE__);
        }
        $this->Forecast_Frequency_Day = $forecast_Frequency_Day;
        return $this;
    }
    /**
     * Get Forecast_Frequency_Week value
     * @return bool|null
     */
    public function getForecast_Frequency_Week()
    {
        return $this->Forecast_Frequency_Week;
    }
    /**
     * Set Forecast_Frequency_Week value
     * @param bool $forecast_Frequency_Week
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setForecast_Frequency_Week($forecast_Frequency_Week = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast_Frequency_Week) && !is_bool($forecast_Frequency_Week)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forecast_Frequency_Week, true), gettype($forecast_Frequency_Week)), __LINE__);
        }
        $this->Forecast_Frequency_Week = $forecast_Frequency_Week;
        return $this;
    }
    /**
     * Get Percent_Allocation_Forecast_Source value
     * @return bool|null
     */
    public function getPercent_Allocation_Forecast_Source()
    {
        return $this->Percent_Allocation_Forecast_Source;
    }
    /**
     * Set Percent_Allocation_Forecast_Source value
     * @param bool $percent_Allocation_Forecast_Source
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setPercent_Allocation_Forecast_Source($percent_Allocation_Forecast_Source = null)
    {
        // validation for constraint: boolean
        if (!is_null($percent_Allocation_Forecast_Source) && !is_bool($percent_Allocation_Forecast_Source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($percent_Allocation_Forecast_Source, true), gettype($percent_Allocation_Forecast_Source)), __LINE__);
        }
        $this->Percent_Allocation_Forecast_Source = $percent_Allocation_Forecast_Source;
        return $this;
    }
    /**
     * Get Estimated_hours_Forecast_Source value
     * @return bool|null
     */
    public function getEstimated_hours_Forecast_Source()
    {
        return $this->Estimated_hours_Forecast_Source;
    }
    /**
     * Set Estimated_hours_Forecast_Source value
     * @param bool $estimated_hours_Forecast_Source
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setEstimated_hours_Forecast_Source($estimated_hours_Forecast_Source = null)
    {
        // validation for constraint: boolean
        if (!is_null($estimated_hours_Forecast_Source) && !is_bool($estimated_hours_Forecast_Source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estimated_hours_Forecast_Source, true), gettype($estimated_hours_Forecast_Source)), __LINE__);
        }
        $this->Estimated_hours_Forecast_Source = $estimated_hours_Forecast_Source;
        return $this;
    }
    /**
     * Get Forecast_Hours_Whole value
     * @return bool|null
     */
    public function getForecast_Hours_Whole()
    {
        return $this->Forecast_Hours_Whole;
    }
    /**
     * Set Forecast_Hours_Whole value
     * @param bool $forecast_Hours_Whole
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setForecast_Hours_Whole($forecast_Hours_Whole = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast_Hours_Whole) && !is_bool($forecast_Hours_Whole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forecast_Hours_Whole, true), gettype($forecast_Hours_Whole)), __LINE__);
        }
        $this->Forecast_Hours_Whole = $forecast_Hours_Whole;
        return $this;
    }
    /**
     * Get Forecast_Hours_Decimal value
     * @return bool|null
     */
    public function getForecast_Hours_Decimal()
    {
        return $this->Forecast_Hours_Decimal;
    }
    /**
     * Set Forecast_Hours_Decimal value
     * @param bool $forecast_Hours_Decimal
     * @return \StructType\Resource_Forecast_Configuration_DataType
     */
    public function setForecast_Hours_Decimal($forecast_Hours_Decimal = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast_Hours_Decimal) && !is_bool($forecast_Hours_Decimal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forecast_Hours_Decimal, true), gettype($forecast_Hours_Decimal)), __LINE__);
        }
        $this->Forecast_Hours_Decimal = $forecast_Hours_Decimal;
        return $this;
    }
}
