<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Web_Item_Attributes_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Put Web Item Attributes Response Element
 * @subpackage Structs
 */
class Put_Web_Item_Attributes_ResponseType extends AbstractStructBase
{
    /**
     * The Web_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Web Item that was updated via this inbound Web Service operation.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Web_Item_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Web_Item_Attributes_ResponseType
     * @uses Put_Web_Item_Attributes_ResponseType::setWeb_Item_Reference()
     * @uses Put_Web_Item_Attributes_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $web_Item_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $web_Item_Reference = null, $version = null)
    {
        $this
            ->setWeb_Item_Reference($web_Item_Reference)
            ->setVersion($version);
    }
    /**
     * Get Web_Item_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getWeb_Item_Reference()
    {
        return $this->Web_Item_Reference;
    }
    /**
     * Set Web_Item_Reference value
     * @param \StructType\Unique_IdentifierObjectType $web_Item_Reference
     * @return \StructType\Put_Web_Item_Attributes_ResponseType
     */
    public function setWeb_Item_Reference(\StructType\Unique_IdentifierObjectType $web_Item_Reference = null)
    {
        $this->Web_Item_Reference = $web_Item_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Web_Item_Attributes_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
