<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Procurement_Document_Attachment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The specified Document is not supported by this Web Service Task. Please refer to the task documentation for supported Documents. | You can't add or remove attachments when the billable transaction is ready to bill. | Element
 * containing Procurement Document reference for attachment adding only and all Attachment data items
 * @subpackage Structs
 */
class Put_Procurement_Document_Attachment_RequestType extends AbstractStructBase
{
    /**
     * The Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Procurement Document for attachment adding only purposes.
     * @var \StructType\Business_DocumentObjectType
     */
    public $Document_Reference;
    /**
     * The Document_Attachment_Data
     * @var \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType
     */
    public $Document_Attachment_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Procurement_Document_Attachment_RequestType
     * @uses Put_Procurement_Document_Attachment_RequestType::setDocument_Reference()
     * @uses Put_Procurement_Document_Attachment_RequestType::setDocument_Attachment_Data()
     * @uses Put_Procurement_Document_Attachment_RequestType::setVersion()
     * @param \StructType\Business_DocumentObjectType $document_Reference
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $document_Attachment_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_DocumentObjectType $document_Reference = null, \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $document_Attachment_Data = null, $version = null)
    {
        $this
            ->setDocument_Reference($document_Reference)
            ->setDocument_Attachment_Data($document_Attachment_Data)
            ->setVersion($version);
    }
    /**
     * Get Document_Reference value
     * @return \StructType\Business_DocumentObjectType|null
     */
    public function getDocument_Reference()
    {
        return $this->Document_Reference;
    }
    /**
     * Set Document_Reference value
     * @param \StructType\Business_DocumentObjectType $document_Reference
     * @return \StructType\Put_Procurement_Document_Attachment_RequestType
     */
    public function setDocument_Reference(\StructType\Business_DocumentObjectType $document_Reference = null)
    {
        $this->Document_Reference = $document_Reference;
        return $this;
    }
    /**
     * Get Document_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType|null
     */
    public function getDocument_Attachment_Data()
    {
        return $this->Document_Attachment_Data;
    }
    /**
     * Set Document_Attachment_Data value
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $document_Attachment_Data
     * @return \StructType\Put_Procurement_Document_Attachment_RequestType
     */
    public function setDocument_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $document_Attachment_Data = null)
    {
        $this->Document_Attachment_Data = $document_Attachment_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Procurement_Document_Attachment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
