<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Internal_Catalog_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Internal Catalog response data for requested references.
 * @subpackage Structs
 */
class Put_Internal_Catalog_ResponseType extends AbstractStructBase
{
    /**
     * The Internal_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Internal Catalog.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_CatalogObjectType
     */
    public $Internal_Catalog_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Internal_Catalog_ResponseType
     * @uses Put_Internal_Catalog_ResponseType::setInternal_Catalog_Reference()
     * @uses Put_Internal_Catalog_ResponseType::setVersion()
     * @param \StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference
     * @param string $version
     */
    public function __construct(\StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference = null, $version = null)
    {
        $this
            ->setInternal_Catalog_Reference($internal_Catalog_Reference)
            ->setVersion($version);
    }
    /**
     * Get Internal_Catalog_Reference value
     * @return \StructType\Internal_Service_CatalogObjectType|null
     */
    public function getInternal_Catalog_Reference()
    {
        return $this->Internal_Catalog_Reference;
    }
    /**
     * Set Internal_Catalog_Reference value
     * @param \StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference
     * @return \StructType\Put_Internal_Catalog_ResponseType
     */
    public function setInternal_Catalog_Reference(\StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference = null)
    {
        $this->Internal_Catalog_Reference = $internal_Catalog_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Internal_Catalog_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
