<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Carriers_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use this element to add information on carrier responses to requests.
 * @subpackage Structs
 */
class Put_Carriers_ResponseType extends AbstractStructBase
{
    /**
     * The Carrier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Carrier Reference
     * - minOccurs: 0
     * @var \StructType\Dock_Carrier__Audited_ObjectType
     */
    public $Carrier_Reference;
    /**
     * The Carrier_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Carriers_DataType[]
     */
    public $Carrier_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Carriers_ResponseType
     * @uses Put_Carriers_ResponseType::setCarrier_Reference()
     * @uses Put_Carriers_ResponseType::setCarrier_Data()
     * @uses Put_Carriers_ResponseType::setVersion()
     * @param \StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference
     * @param \StructType\Carriers_DataType[] $carrier_Data
     * @param string $version
     */
    public function __construct(\StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference = null, array $carrier_Data = array(), $version = null)
    {
        $this
            ->setCarrier_Reference($carrier_Reference)
            ->setCarrier_Data($carrier_Data)
            ->setVersion($version);
    }
    /**
     * Get Carrier_Reference value
     * @return \StructType\Dock_Carrier__Audited_ObjectType|null
     */
    public function getCarrier_Reference()
    {
        return $this->Carrier_Reference;
    }
    /**
     * Set Carrier_Reference value
     * @param \StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference
     * @return \StructType\Put_Carriers_ResponseType
     */
    public function setCarrier_Reference(\StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference = null)
    {
        $this->Carrier_Reference = $carrier_Reference;
        return $this;
    }
    /**
     * Get Carrier_Data value
     * @return \StructType\Carriers_DataType[]|null
     */
    public function getCarrier_Data()
    {
        return $this->Carrier_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrier_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrier_DataForArrayConstraintsFromSetCarrier_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Carriers_ResponseTypeCarrier_DataItem) {
            // validation for constraint: itemType
            if (!$put_Carriers_ResponseTypeCarrier_DataItem instanceof \StructType\Carriers_DataType) {
                $invalidValues[] = is_object($put_Carriers_ResponseTypeCarrier_DataItem) ? get_class($put_Carriers_ResponseTypeCarrier_DataItem) : sprintf('%s(%s)', gettype($put_Carriers_ResponseTypeCarrier_DataItem), var_export($put_Carriers_ResponseTypeCarrier_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Carrier_Data property can only contain items of type \StructType\Carriers_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Carrier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Carriers_DataType[] $carrier_Data
     * @return \StructType\Put_Carriers_ResponseType
     */
    public function setCarrier_Data(array $carrier_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($carrier_DataArrayErrorMessage = self::validateCarrier_DataForArrayConstraintsFromSetCarrier_Data($carrier_Data))) {
            throw new \InvalidArgumentException($carrier_DataArrayErrorMessage, __LINE__);
        }
        $this->Carrier_Data = $carrier_Data;
        return $this;
    }
    /**
     * Add item to Carrier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Carriers_DataType $item
     * @return \StructType\Put_Carriers_ResponseType
     */
    public function addToCarrier_Data(\StructType\Carriers_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Carriers_DataType) {
            throw new \InvalidArgumentException(sprintf('The Carrier_Data property can only contain items of type \StructType\Carriers_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Carrier_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Carriers_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
