<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Project plan data
 * @subpackage Structs
 */
class Project_Plan_DataType extends AbstractStructBase
{
    /**
     * The Project_ID
     * Meta information extracted from the WSDL
     * - documentation: Project ID. This is unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_ID;
    /**
     * The Project_Plan_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Plan Template (Not available in GET Operation)
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TemplateObjectType
     */
    public $Project_Plan_Template_Reference;
    /**
     * The Project_Plan_Phase_Data
     * Meta information extracted from the WSDL
     * - documentation: Element Containing Project Plan Phase Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Phase_WWS_DataType[]
     */
    public $Project_Plan_Phase_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: If Replace All is set to True, a full sync will be performed once the web service is submitted.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Project_Plan_DataType
     * @uses Project_Plan_DataType::setProject_ID()
     * @uses Project_Plan_DataType::setProject_Plan_Template_Reference()
     * @uses Project_Plan_DataType::setProject_Plan_Phase_Data()
     * @uses Project_Plan_DataType::setReplace_All()
     * @param string $project_ID
     * @param \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference
     * @param \StructType\Project_Plan_Phase_WWS_DataType[] $project_Plan_Phase_Data
     * @param bool $replace_All
     */
    public function __construct($project_ID = null, \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference = null, array $project_Plan_Phase_Data = array(), $replace_All = null)
    {
        $this
            ->setProject_ID($project_ID)
            ->setProject_Plan_Template_Reference($project_Plan_Template_Reference)
            ->setProject_Plan_Phase_Data($project_Plan_Phase_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Project_ID value
     * @return string|null
     */
    public function getProject_ID()
    {
        return $this->Project_ID;
    }
    /**
     * Set Project_ID value
     * @param string $project_ID
     * @return \StructType\Project_Plan_DataType
     */
    public function setProject_ID($project_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_ID) && !is_string($project_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_ID, true), gettype($project_ID)), __LINE__);
        }
        $this->Project_ID = $project_ID;
        return $this;
    }
    /**
     * Get Project_Plan_Template_Reference value
     * @return \StructType\Project_Plan_TemplateObjectType|null
     */
    public function getProject_Plan_Template_Reference()
    {
        return $this->Project_Plan_Template_Reference;
    }
    /**
     * Set Project_Plan_Template_Reference value
     * @param \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference
     * @return \StructType\Project_Plan_DataType
     */
    public function setProject_Plan_Template_Reference(\StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference = null)
    {
        $this->Project_Plan_Template_Reference = $project_Plan_Template_Reference;
        return $this;
    }
    /**
     * Get Project_Plan_Phase_Data value
     * @return \StructType\Project_Plan_Phase_WWS_DataType[]|null
     */
    public function getProject_Plan_Phase_Data()
    {
        return $this->Project_Plan_Phase_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan_Phase_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan_Phase_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Plan_Phase_DataForArrayConstraintsFromSetProject_Plan_Phase_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_DataTypeProject_Plan_Phase_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_DataTypeProject_Plan_Phase_DataItem instanceof \StructType\Project_Plan_Phase_WWS_DataType) {
                $invalidValues[] = is_object($project_Plan_DataTypeProject_Plan_Phase_DataItem) ? get_class($project_Plan_DataTypeProject_Plan_Phase_DataItem) : sprintf('%s(%s)', gettype($project_Plan_DataTypeProject_Plan_Phase_DataItem), var_export($project_Plan_DataTypeProject_Plan_Phase_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan_Phase_Data property can only contain items of type \StructType\Project_Plan_Phase_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_WWS_DataType[] $project_Plan_Phase_Data
     * @return \StructType\Project_Plan_DataType
     */
    public function setProject_Plan_Phase_Data(array $project_Plan_Phase_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Plan_Phase_DataArrayErrorMessage = self::validateProject_Plan_Phase_DataForArrayConstraintsFromSetProject_Plan_Phase_Data($project_Plan_Phase_Data))) {
            throw new \InvalidArgumentException($project_Plan_Phase_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan_Phase_Data = $project_Plan_Phase_Data;
        return $this;
    }
    /**
     * Add item to Project_Plan_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_WWS_DataType $item
     * @return \StructType\Project_Plan_DataType
     */
    public function addToProject_Plan_Phase_Data(\StructType\Project_Plan_Phase_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Phase_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan_Phase_Data property can only contain items of type \StructType\Project_Plan_Phase_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan_Phase_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Project_Plan_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
