<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Tag_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The item tag request references element.
 * @subpackage Structs
 */
class Item_Tag_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The request references to the item tag.
     * - maxOccurs: unbounded
     * @var \StructType\Item_TagObjectType[]
     */
    public $Item_Tag_Reference;
    /**
     * Constructor method for Item_Tag_Request_ReferencesType
     * @uses Item_Tag_Request_ReferencesType::setItem_Tag_Reference()
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     */
    public function __construct(array $item_Tag_Reference = array())
    {
        $this
            ->setItem_Tag_Reference($item_Tag_Reference);
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType[]|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Tag_Request_ReferencesTypeItem_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Tag_Request_ReferencesTypeItem_Tag_ReferenceItem instanceof \StructType\Item_TagObjectType) {
                $invalidValues[] = is_object($item_Tag_Request_ReferencesTypeItem_Tag_ReferenceItem) ? get_class($item_Tag_Request_ReferencesTypeItem_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($item_Tag_Request_ReferencesTypeItem_Tag_ReferenceItem), var_export($item_Tag_Request_ReferencesTypeItem_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @return \StructType\Item_Tag_Request_ReferencesType
     */
    public function setItem_Tag_Reference(array $item_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_ReferenceArrayErrorMessage = self::validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference($item_Tag_Reference))) {
            throw new \InvalidArgumentException($item_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType $item
     * @return \StructType\Item_Tag_Request_ReferencesType
     */
    public function addToItem_Tag_Reference(\StructType\Item_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Reference[] = $item;
        return $this;
    }
}
