<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Type_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Invoice Type Request Reference element contains the specific instance containing the requested Invoice Type.
 * @subpackage Structs
 */
class Invoice_Type_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Business Object containing the Invoice Type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType[]
     */
    public $Invoice_Type_Reference;
    /**
     * Constructor method for Invoice_Type_Request_ReferencesType
     * @uses Invoice_Type_Request_ReferencesType::setInvoice_Type_Reference()
     * @param \StructType\Invoice_TypeObjectType[] $invoice_Type_Reference
     */
    public function __construct(array $invoice_Type_Reference = array())
    {
        $this
            ->setInvoice_Type_Reference($invoice_Type_Reference);
    }
    /**
     * Get Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType[]|null
     */
    public function getInvoice_Type_Reference()
    {
        return $this->Invoice_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_Type_ReferenceForArrayConstraintsFromSetInvoice_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoice_Type_Request_ReferencesTypeInvoice_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$invoice_Type_Request_ReferencesTypeInvoice_Type_ReferenceItem instanceof \StructType\Invoice_TypeObjectType) {
                $invalidValues[] = is_object($invoice_Type_Request_ReferencesTypeInvoice_Type_ReferenceItem) ? get_class($invoice_Type_Request_ReferencesTypeInvoice_Type_ReferenceItem) : sprintf('%s(%s)', gettype($invoice_Type_Request_ReferencesTypeInvoice_Type_ReferenceItem), var_export($invoice_Type_Request_ReferencesTypeInvoice_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Type_Reference property can only contain items of type \StructType\Invoice_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_TypeObjectType[] $invoice_Type_Reference
     * @return \StructType\Invoice_Type_Request_ReferencesType
     */
    public function setInvoice_Type_Reference(array $invoice_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_Type_ReferenceArrayErrorMessage = self::validateInvoice_Type_ReferenceForArrayConstraintsFromSetInvoice_Type_Reference($invoice_Type_Reference))) {
            throw new \InvalidArgumentException($invoice_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Type_Reference = $invoice_Type_Reference;
        return $this;
    }
    /**
     * Add item to Invoice_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_TypeObjectType $item
     * @return \StructType\Invoice_Type_Request_ReferencesType
     */
    public function addToInvoice_Type_Reference(\StructType\Invoice_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Invoice_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Type_Reference property can only contain items of type \StructType\Invoice_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Type_Reference[] = $item;
        return $this;
    }
}
