<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Catalog_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: "References" element allowing the specification of specific object instances to be returned based on ID values.
 * @subpackage Structs
 */
class Internal_Catalog_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Internal_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Internal Service Catalogs
     * - maxOccurs: unbounded
     * @var \StructType\Internal_Service_CatalogObjectType[]
     */
    public $Internal_Catalog_Reference;
    /**
     * Constructor method for Internal_Catalog_Request_ReferencesType
     * @uses Internal_Catalog_Request_ReferencesType::setInternal_Catalog_Reference()
     * @param \StructType\Internal_Service_CatalogObjectType[] $internal_Catalog_Reference
     */
    public function __construct(array $internal_Catalog_Reference = array())
    {
        $this
            ->setInternal_Catalog_Reference($internal_Catalog_Reference);
    }
    /**
     * Get Internal_Catalog_Reference value
     * @return \StructType\Internal_Service_CatalogObjectType[]|null
     */
    public function getInternal_Catalog_Reference()
    {
        return $this->Internal_Catalog_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Catalog_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Catalog_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Catalog_ReferenceForArrayConstraintsFromSetInternal_Catalog_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Catalog_Request_ReferencesTypeInternal_Catalog_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Catalog_Request_ReferencesTypeInternal_Catalog_ReferenceItem instanceof \StructType\Internal_Service_CatalogObjectType) {
                $invalidValues[] = is_object($internal_Catalog_Request_ReferencesTypeInternal_Catalog_ReferenceItem) ? get_class($internal_Catalog_Request_ReferencesTypeInternal_Catalog_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Catalog_Request_ReferencesTypeInternal_Catalog_ReferenceItem), var_export($internal_Catalog_Request_ReferencesTypeInternal_Catalog_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Catalog_Reference property can only contain items of type \StructType\Internal_Service_CatalogObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_CatalogObjectType[] $internal_Catalog_Reference
     * @return \StructType\Internal_Catalog_Request_ReferencesType
     */
    public function setInternal_Catalog_Reference(array $internal_Catalog_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Catalog_ReferenceArrayErrorMessage = self::validateInternal_Catalog_ReferenceForArrayConstraintsFromSetInternal_Catalog_Reference($internal_Catalog_Reference))) {
            throw new \InvalidArgumentException($internal_Catalog_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Internal_Catalog_Reference = $internal_Catalog_Reference;
        return $this;
    }
    /**
     * Add item to Internal_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_CatalogObjectType $item
     * @return \StructType\Internal_Catalog_Request_ReferencesType
     */
    public function addToInternal_Catalog_Reference(\StructType\Internal_Service_CatalogObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_CatalogObjectType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Catalog_Reference property can only contain items of type \StructType\Internal_Service_CatalogObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Catalog_Reference[] = $item;
        return $this;
    }
}
