<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Workers_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter a valid ID for a current, active Contingent Worker with no open transaction documents and with no merge history or record. | This Element contains Contingent Worker attributes.
 * @subpackage Structs
 */
class Contingent_Workers_DataType extends AbstractStructBase
{
    /**
     * The Contingent_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contingent Worker Reference
     * @var \StructType\Contingent_WorkerObjectType
     */
    public $Contingent_Worker_Reference;
    /**
     * The Contingent_Worker_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Contingent Worker
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contingent_Worker_Name;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * Constructor method for Contingent_Workers_DataType
     * @uses Contingent_Workers_DataType::setContingent_Worker_Reference()
     * @uses Contingent_Workers_DataType::setContingent_Worker_Name()
     * @uses Contingent_Workers_DataType::setSupplier_Reference()
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @param string $contingent_Worker_Name
     * @param \StructType\SupplierObjectType $supplier_Reference
     */
    public function __construct(\StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null, $contingent_Worker_Name = null, \StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this
            ->setContingent_Worker_Reference($contingent_Worker_Reference)
            ->setContingent_Worker_Name($contingent_Worker_Name)
            ->setSupplier_Reference($supplier_Reference);
    }
    /**
     * Get Contingent_Worker_Reference value
     * @return \StructType\Contingent_WorkerObjectType|null
     */
    public function getContingent_Worker_Reference()
    {
        return $this->Contingent_Worker_Reference;
    }
    /**
     * Set Contingent_Worker_Reference value
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @return \StructType\Contingent_Workers_DataType
     */
    public function setContingent_Worker_Reference(\StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null)
    {
        $this->Contingent_Worker_Reference = $contingent_Worker_Reference;
        return $this;
    }
    /**
     * Get Contingent_Worker_Name value
     * @return string|null
     */
    public function getContingent_Worker_Name()
    {
        return $this->Contingent_Worker_Name;
    }
    /**
     * Set Contingent_Worker_Name value
     * @param string $contingent_Worker_Name
     * @return \StructType\Contingent_Workers_DataType
     */
    public function setContingent_Worker_Name($contingent_Worker_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contingent_Worker_Name) && !is_string($contingent_Worker_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contingent_Worker_Name, true), gettype($contingent_Worker_Name)), __LINE__);
        }
        $this->Contingent_Worker_Name = $contingent_Worker_Name;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Contingent_Workers_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
}
