<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Depreciation_Schedule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Asset Depreciation Schedule data that may be updated by Update Asset Depreciation Schedule operation.
 * @subpackage Structs
 */
class Asset_Depreciation_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Add_Only;
    /**
     * The Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: There is a pending event for the asset that should be completed before this asset transaction can be processed. | The primary ID of the asset of this asset depreciation schedule. The value of this field and the asset book reference
     * represent a unique ID that can be used to identify this asset depreciation schedule instance
     * - maxOccurs: 1
     * @var string
     */
    public $Asset_ID;
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value to an asset book used by the asset company. A value is required for every asset depreciation schedule. The value of this book cannot be the primary book for the asset company.
     * @var \StructType\Asset_BookObjectType
     */
    public $Asset_Book_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value to an existing accounting treatment. Workday supplies the accounting treatments Expense, Depreciable Capital and Non-Depreciable Capital. It is required for every asset depreciation schedule.
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Depreciation_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Depreciation profile must be blank when accounting treatment is not depreciable capital | Depreciation Profile is required when accounting treatment is Depreciable Capital | Reference to depreciation profile used by this asset
     * depreciation schedule. It is required of the accounting treatment is depreciable capital.
     * - minOccurs: 0
     * @var \StructType\Depreciation_ProfileObjectType
     */
    public $Depreciation_Profile_Reference;
    /**
     * The Depreciation_Convention_Reference
     * Meta information extracted from the WSDL
     * - documentation: Depreciation Convention is required when accounting treatment is depreciable capital | Depreciation convention must be blank when accounting treatment is not depreciable capital | Reference to depreciation convention used by this
     * asset depreciation schedule. It is required if the accounting treatment is depreciable capital.In order to assign 'Half-Year' as the depreciation convention, the company asset book must use a fiscal schedule with an even number of fiscal periods per
     * fiscal year.In order to assign 'Mid-Quarter' as the depreciation convention, the company asset book must use a fiscal schedule where number of fiscal periods per fiscal year is divisible by 4.
     * - minOccurs: 0
     * @var \StructType\Depreciation_ConventionObjectType
     */
    public $Depreciation_Convention_Reference;
    /**
     * The Depreciation_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Depreciation method must be blank when accounting treatment is not depreciable capital | Depreciation Method is required when accounting treatment is Depreciable Capital | Reference to depreciation method used by this asset
     * depreciation schedule. It is required if the accounting treatment is depreciable capital
     * - minOccurs: 0
     * @var \StructType\Abstract_Depreciation_MethodObjectType
     */
    public $Depreciation_Method_Reference;
    /**
     * The Depreciation_Percent
     * Meta information extracted from the WSDL
     * - documentation: The depreciation percent for this asset. | Numeric value representing the depreciation percent for Declining Balance with Switch to Straight Line method. It is required when the depreciation method is declining balance. It left
     * blank, it will be defaulted from the depreciation profile. | Depreciation percent must be zero unless you are using Declining Balance or Declining Balance Switch to Straight Line Depreciation Methods. | Depreciation percent should be greater than 100
     * when the depreciation method is Declining Balance Switch to SL. | Depreciation percent must be greater than 0 and less than 100 when the depreciation method is Declining Balance. | Enter Depreciation Percent when overriding depreciation profile
     * information and depreciation method is Declining Balance (with and without switch to Straight Line).
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Depreciation_Percent;
    /**
     * The Useful_Life__Periods_
     * Meta information extracted from the WSDL
     * - documentation: Numeric value representing the useful life (in periods) for the asset depreciation schedule. It is required if the accounting treatment is depreciable capital. If left blank it will be defaulted from the depreciation profile. |
     * Useful Life cannot be more than 200 years. Useful life in years is useful life in periods divided by number of periods in the company's fiscal year. | Useful Life must be equal to zero if the Depreciation Method is Declining Balance.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Useful_Life__Periods_;
    /**
     * The Depreciation_Threshold
     * Meta information extracted from the WSDL
     * - documentation: The depreciation threshold for this asset. | Depreciation Threshold. Enter only if method is declining balance. | Only Declining Balance Depreciation Method can have a threshold. | Declining Balance Depreciation Method must have a
     * threshold. | Depreciation Threshold is greater than Total Asset Cost.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Depreciation_Threshold;
    /**
     * The Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Workday uses these dates to update External Contract Start and End date if you manually register the asset but updates the In service Start and End date for all other sources.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Start_Date;
    /**
     * The Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Workday uses these dates to update External Contract Start and End date if you manually register the asset but updates the In service Start and End date for all other sources.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date;
    /**
     * The Date_Placed_in_Service
     * Meta information extracted from the WSDL
     * - documentation: Date placed in service cannot be prior to date acquired | Date placed in service cannot be after depreciation start date | Date placed in service cannot be after the date the asset first issued. | Date placed in service must be the
     * same as asset acquisition date or must be left blank when Place in Service option is Upon Acquisition | Date placed in service must be blank when accounting treatment is not depreciable capital | Date value representing the date this asset
     * depreciation schedule is placed in service. It is required if the depreciation schedule has historical information. It cannot be after depreciation start date and prior to the asset acquisition date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Placed_in_Service;
    /**
     * The Bonus_Depreciation_Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage that will be used to calculate the depreciable basis for bonus depreciation. | Numeric value representing bonus depreciation percent for this asset depreciation schedule. Value cannot be more than 100. | Bonus
     * depreciation percent must be 0 when accounting treatment is not depreciable capital | Bonus depreciation percent cannot be more than 100
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Bonus_Depreciation_Percent;
    /**
     * The Max_Bonus_Depreciable_Basis
     * Meta information extracted from the WSDL
     * - documentation: The maximum allowable bonus depreciation that can be taken for a particular asset, i.e. the upper limit for depreciation. | Numeric value representing the maximum bonus depreciation basis. Workday would use the lesser of this field
     * and asset cost that is applicable to bonus depreciation to calculated the bonus amount. | Max Depreciable Basis must be 0 when accounting treatment is not depreciable capital | The max bonus depreciable basis entered has too many digits beyond the
     * decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Max_Bonus_Depreciable_Basis;
    /**
     * The Depreciation_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Depreciation Start Date cannot be prior to the date the asset was transferred to this company | Depreciation start date cannot be prior to the effective transaction date of an adjustment if the remaining depreciation periods is 0 |
     * You cannot update depreciation schedule historical information if the schedule was created by Intercompany Transfer transaction | Depreciation start date must be blank when accounting treatment is not depreciable capital | Depreciation Start Date
     * must match start date of the first fiscal period that depreciation is to start in Workday. | Fiscal period must exist in fiscal schedule for depreciation start date | Depreciation Start Date cannot be prior to acquisition date of the asset | For
     * converted assets, the depreciation start date represents the date that depreciation starts in Workday. For converted assets with historical accumulated depreciation, the depreciation start date should be 1 day greater than the date up to which the
     * historical accumulated depreciation is calculated. The date cannot be prior to the acquisition date. For converted assets with no historical accumulated depreciation, leave the depreciation start date blank so that Workday can determine the correct
     * date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Depreciation_Start_Date;
    /**
     * The Remaining_Depreciation_Periods
     * Meta information extracted from the WSDL
     * - documentation: Numeric value for remaining depreciation periods if entering accumulated depreciation from a prior system. | Remaining depreciation periods must be 0 when depreciation method is Term or Declining Balance. | Remaining Depreciation
     * Periods cannot be greater than useful life in periods provided or defaulted from profile for spend category | Numeric value for remaining depreciation periods if entering accumulated depreciation from a prior system and depreciation start date.
     * Workday will generate depreciation entries for this schedule for the number of remaining periods. | Remaining depreciation periods is required when you enter Accumulated Depreciation | The fiscal period must exist for the depreciation start date in
     * the fiscal schedule for the company asset book. | Remaining depreciation periods must be 0 when depreciation start date is blank | Remaining depreciation periods cannot be greater than useful life | When depreciation is based on the number of days
     * per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation amount for each period correctly. In order to complete the depreciation setup for this asset and create the
     * depreciation schedule, you will need to create additional fiscal years / periods for fiscal schedule linked to the company asset book(s).
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Remaining_Depreciation_Periods;
    /**
     * The Original_Acquisition_Cost
     * Meta information extracted from the WSDL
     * - documentation: The Unit Cost of Asset for the specified Book
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Original_Acquisition_Cost;
    /**
     * The Total_Asset_Cost
     * Meta information extracted from the WSDL
     * - documentation: Total Asset Cost | The total asset cost entered has too many digits beyond the decimal point | The current total cost of this asset. | This field is for display only, any values updated will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Asset_Cost;
    /**
     * The Residual_Value
     * Meta information extracted from the WSDL
     * - documentation: Residual or salvage value | Residual value cannot be greater than acquisition (unit) cost. | The residual value entered has too many digits beyond the decimal point | The current residual value of this asset. | Residual or salvage
     * value for the specified Book
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Residual_Value;
    /**
     * The Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: Fair Market Value | The fair market value entered has too many digits beyond the decimal point | Fair Market Value for the specified book
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Fair_Market_Value;
    /**
     * The Accumulated_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Accumulated Depreciation | Accumulated Depreciation cannot be greater than Acquisition Cost minus Residual Value | The accumulated depreciation amount at the time the asset was transferred to a different company. | Numeric value
     * representing historical accumulated depreciation as of a day prior to depreciation start date. This value cannot be greater than historical cost minus historical residual value. Workday uses this accumulated depreciation value to determine
     * depreciable cost basis to generate the depreciation schedule for remaining useful life starting from depreciation start date. | Accumulated depreciation cannot be greater than cost minus residual value for the asset book | Accumulated depreciation
     * must be 0 when depreciation start date is blank | Accumulated depreciation is required when depreciation start date has a value | The accumulated depreciation entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Accumulated_Depreciation;
    /**
     * The Year_to_Date_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Numeric value representing year-to-date depreciation as of a day period to depreciation start date. This field is required if the asset depreciation schedule has historical information and the depreciation method is either declining
     * balance or sum of years digits. The value of this field cannot be greater than historical accumulated depreciation. | Year to date depreciation is required if depreciation method is Declining Balance with Switch to Straight Line or Sum of Years and
     * depreciation start date is not in the first period of the fiscal year | Year To Date depreciation cannot be greater than accumulated depreciation | The year to date depreciation entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Year_to_Date_Depreciation;
    /**
     * The Historical_Bonus_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Numeric value representing historical bonus depreciation amount. This field is required if the depreciation schedule has historical information and bonus depreciation percent is populated, else it should be left empty. The value of
     * this field cannot be greater than accumulated depreciation. | Historical bonus depreciation amount must be 0 when accounting treatment is not depreciable capital | Historical bonus depreciation amount cannot be greater than accumulated depreciation |
     * The historical bonus depreciation entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Historical_Bonus_Depreciation;
    /**
     * The Asset_Book_Configuration_Additional_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Asset_Depreciation_Schedule_Additional_InformationType
     */
    public $Asset_Book_Configuration_Additional_Data;
    /**
     * The Asset_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public $Asset_Data;
    /**
     * Constructor method for Asset_Depreciation_Schedule_DataType
     * @uses Asset_Depreciation_Schedule_DataType::setAdd_Only()
     * @uses Asset_Depreciation_Schedule_DataType::setAsset_ID()
     * @uses Asset_Depreciation_Schedule_DataType::setAsset_Book_Reference()
     * @uses Asset_Depreciation_Schedule_DataType::setAccounting_Treatment_Reference()
     * @uses Asset_Depreciation_Schedule_DataType::setDepreciation_Profile_Reference()
     * @uses Asset_Depreciation_Schedule_DataType::setDepreciation_Convention_Reference()
     * @uses Asset_Depreciation_Schedule_DataType::setDepreciation_Method_Reference()
     * @uses Asset_Depreciation_Schedule_DataType::setDepreciation_Percent()
     * @uses Asset_Depreciation_Schedule_DataType::setUseful_Life__Periods_()
     * @uses Asset_Depreciation_Schedule_DataType::setDepreciation_Threshold()
     * @uses Asset_Depreciation_Schedule_DataType::setContract_Start_Date()
     * @uses Asset_Depreciation_Schedule_DataType::setContract_End_Date()
     * @uses Asset_Depreciation_Schedule_DataType::setDate_Placed_in_Service()
     * @uses Asset_Depreciation_Schedule_DataType::setBonus_Depreciation_Percent()
     * @uses Asset_Depreciation_Schedule_DataType::setMax_Bonus_Depreciable_Basis()
     * @uses Asset_Depreciation_Schedule_DataType::setDepreciation_Start_Date()
     * @uses Asset_Depreciation_Schedule_DataType::setRemaining_Depreciation_Periods()
     * @uses Asset_Depreciation_Schedule_DataType::setOriginal_Acquisition_Cost()
     * @uses Asset_Depreciation_Schedule_DataType::setTotal_Asset_Cost()
     * @uses Asset_Depreciation_Schedule_DataType::setResidual_Value()
     * @uses Asset_Depreciation_Schedule_DataType::setFair_Market_Value()
     * @uses Asset_Depreciation_Schedule_DataType::setAccumulated_Depreciation()
     * @uses Asset_Depreciation_Schedule_DataType::setYear_to_Date_Depreciation()
     * @uses Asset_Depreciation_Schedule_DataType::setHistorical_Bonus_Depreciation()
     * @uses Asset_Depreciation_Schedule_DataType::setAsset_Book_Configuration_Additional_Data()
     * @uses Asset_Depreciation_Schedule_DataType::setAsset_Data()
     * @param bool $add_Only
     * @param string $asset_ID
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @param \StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference
     * @param \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference
     * @param float $depreciation_Percent
     * @param float $useful_Life__Periods_
     * @param float $depreciation_Threshold
     * @param string $contract_Start_Date
     * @param string $contract_End_Date
     * @param string $date_Placed_in_Service
     * @param float $bonus_Depreciation_Percent
     * @param float $max_Bonus_Depreciable_Basis
     * @param string $depreciation_Start_Date
     * @param float $remaining_Depreciation_Periods
     * @param float $original_Acquisition_Cost
     * @param float $total_Asset_Cost
     * @param float $residual_Value
     * @param float $fair_Market_Value
     * @param float $accumulated_Depreciation
     * @param float $year_to_Date_Depreciation
     * @param float $historical_Bonus_Depreciation
     * @param \StructType\Asset_Depreciation_Schedule_Additional_InformationType $asset_Book_Configuration_Additional_Data
     * @param \StructType\Asset_for_Depreciation_Schedule_DataType $asset_Data
     */
    public function __construct($add_Only = null, $asset_ID = null, \StructType\Asset_BookObjectType $asset_Book_Reference = null, \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null, \StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference = null, \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference = null, $depreciation_Percent = null, $useful_Life__Periods_ = null, $depreciation_Threshold = null, $contract_Start_Date = null, $contract_End_Date = null, $date_Placed_in_Service = null, $bonus_Depreciation_Percent = null, $max_Bonus_Depreciable_Basis = null, $depreciation_Start_Date = null, $remaining_Depreciation_Periods = null, $original_Acquisition_Cost = null, $total_Asset_Cost = null, $residual_Value = null, $fair_Market_Value = null, $accumulated_Depreciation = null, $year_to_Date_Depreciation = null, $historical_Bonus_Depreciation = null, \StructType\Asset_Depreciation_Schedule_Additional_InformationType $asset_Book_Configuration_Additional_Data = null, \StructType\Asset_for_Depreciation_Schedule_DataType $asset_Data = null)
    {
        $this
            ->setAdd_Only($add_Only)
            ->setAsset_ID($asset_ID)
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setDepreciation_Profile_Reference($depreciation_Profile_Reference)
            ->setDepreciation_Convention_Reference($depreciation_Convention_Reference)
            ->setDepreciation_Method_Reference($depreciation_Method_Reference)
            ->setDepreciation_Percent($depreciation_Percent)
            ->setUseful_Life__Periods_($useful_Life__Periods_)
            ->setDepreciation_Threshold($depreciation_Threshold)
            ->setContract_Start_Date($contract_Start_Date)
            ->setContract_End_Date($contract_End_Date)
            ->setDate_Placed_in_Service($date_Placed_in_Service)
            ->setBonus_Depreciation_Percent($bonus_Depreciation_Percent)
            ->setMax_Bonus_Depreciable_Basis($max_Bonus_Depreciable_Basis)
            ->setDepreciation_Start_Date($depreciation_Start_Date)
            ->setRemaining_Depreciation_Periods($remaining_Depreciation_Periods)
            ->setOriginal_Acquisition_Cost($original_Acquisition_Cost)
            ->setTotal_Asset_Cost($total_Asset_Cost)
            ->setResidual_Value($residual_Value)
            ->setFair_Market_Value($fair_Market_Value)
            ->setAccumulated_Depreciation($accumulated_Depreciation)
            ->setYear_to_Date_Depreciation($year_to_Date_Depreciation)
            ->setHistorical_Bonus_Depreciation($historical_Bonus_Depreciation)
            ->setAsset_Book_Configuration_Additional_Data($asset_Book_Configuration_Additional_Data)
            ->setAsset_Data($asset_Data);
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Asset_ID value
     * @return string|null
     */
    public function getAsset_ID()
    {
        return $this->Asset_ID;
    }
    /**
     * Set Asset_ID value
     * @param string $asset_ID
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAsset_ID($asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($asset_ID) && !is_string($asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_ID, true), gettype($asset_ID)), __LINE__);
        }
        $this->Asset_ID = $asset_ID;
        return $this;
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * Set Asset_Book_Reference value
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAsset_Book_Reference(\StructType\Asset_BookObjectType $asset_Book_Reference = null)
    {
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Profile_Reference value
     * @return \StructType\Depreciation_ProfileObjectType|null
     */
    public function getDepreciation_Profile_Reference()
    {
        return $this->Depreciation_Profile_Reference;
    }
    /**
     * Set Depreciation_Profile_Reference value
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDepreciation_Profile_Reference(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null)
    {
        $this->Depreciation_Profile_Reference = $depreciation_Profile_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Convention_Reference value
     * @return \StructType\Depreciation_ConventionObjectType|null
     */
    public function getDepreciation_Convention_Reference()
    {
        return $this->Depreciation_Convention_Reference;
    }
    /**
     * Set Depreciation_Convention_Reference value
     * @param \StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDepreciation_Convention_Reference(\StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference = null)
    {
        $this->Depreciation_Convention_Reference = $depreciation_Convention_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Method_Reference value
     * @return \StructType\Abstract_Depreciation_MethodObjectType|null
     */
    public function getDepreciation_Method_Reference()
    {
        return $this->Depreciation_Method_Reference;
    }
    /**
     * Set Depreciation_Method_Reference value
     * @param \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDepreciation_Method_Reference(\StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference = null)
    {
        $this->Depreciation_Method_Reference = $depreciation_Method_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Percent value
     * @return float|null
     */
    public function getDepreciation_Percent()
    {
        return $this->Depreciation_Percent;
    }
    /**
     * Set Depreciation_Percent value
     * @param float $depreciation_Percent
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDepreciation_Percent($depreciation_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Percent) && !(is_float($depreciation_Percent) || is_numeric($depreciation_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Percent, true), gettype($depreciation_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($depreciation_Percent) && mb_strlen(mb_substr($depreciation_Percent, false !== mb_strpos($depreciation_Percent, '.') ? mb_strpos($depreciation_Percent, '.') + 1 : mb_strlen($depreciation_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($depreciation_Percent, true), mb_strlen(mb_substr($depreciation_Percent, mb_strpos($depreciation_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($depreciation_Percent) && $depreciation_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($depreciation_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($depreciation_Percent) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Percent)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($depreciation_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Percent))), __LINE__);
        }
        $this->Depreciation_Percent = $depreciation_Percent;
        return $this;
    }
    /**
     * Get Useful_Life__Periods_ value
     * @return float|null
     */
    public function getUseful_Life__Periods_()
    {
        return $this->Useful_Life__Periods_;
    }
    /**
     * Set Useful_Life__Periods_ value
     * @param float $useful_Life__Periods_
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setUseful_Life__Periods_($useful_Life__Periods_ = null)
    {
        // validation for constraint: float
        if (!is_null($useful_Life__Periods_) && !(is_float($useful_Life__Periods_) || is_numeric($useful_Life__Periods_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($useful_Life__Periods_, true), gettype($useful_Life__Periods_)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($useful_Life__Periods_) && mb_strlen(mb_substr($useful_Life__Periods_, false !== mb_strpos($useful_Life__Periods_, '.') ? mb_strpos($useful_Life__Periods_, '.') + 1 : mb_strlen($useful_Life__Periods_))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($useful_Life__Periods_, true), mb_strlen(mb_substr($useful_Life__Periods_, mb_strpos($useful_Life__Periods_, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($useful_Life__Periods_) && $useful_Life__Periods_ < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($useful_Life__Periods_, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($useful_Life__Periods_) && mb_strlen(preg_replace('/(\D)/', '', $useful_Life__Periods_)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($useful_Life__Periods_, true), mb_strlen(preg_replace('/(\D)/', '', $useful_Life__Periods_))), __LINE__);
        }
        $this->Useful_Life__Periods_ = $useful_Life__Periods_;
        return $this;
    }
    /**
     * Get Depreciation_Threshold value
     * @return float|null
     */
    public function getDepreciation_Threshold()
    {
        return $this->Depreciation_Threshold;
    }
    /**
     * Set Depreciation_Threshold value
     * @param float $depreciation_Threshold
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDepreciation_Threshold($depreciation_Threshold = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Threshold) && !(is_float($depreciation_Threshold) || is_numeric($depreciation_Threshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Threshold, true), gettype($depreciation_Threshold)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($depreciation_Threshold) && mb_strlen(mb_substr($depreciation_Threshold, false !== mb_strpos($depreciation_Threshold, '.') ? mb_strpos($depreciation_Threshold, '.') + 1 : mb_strlen($depreciation_Threshold))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($depreciation_Threshold, true), mb_strlen(mb_substr($depreciation_Threshold, mb_strpos($depreciation_Threshold, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($depreciation_Threshold) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Threshold)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($depreciation_Threshold, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Threshold))), __LINE__);
        }
        $this->Depreciation_Threshold = $depreciation_Threshold;
        return $this;
    }
    /**
     * Get Contract_Start_Date value
     * @return string|null
     */
    public function getContract_Start_Date()
    {
        return $this->Contract_Start_Date;
    }
    /**
     * Set Contract_Start_Date value
     * @param string $contract_Start_Date
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setContract_Start_Date($contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date) && !is_string($contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date, true), gettype($contract_Start_Date)), __LINE__);
        }
        $this->Contract_Start_Date = $contract_Start_Date;
        return $this;
    }
    /**
     * Get Contract_End_Date value
     * @return string|null
     */
    public function getContract_End_Date()
    {
        return $this->Contract_End_Date;
    }
    /**
     * Set Contract_End_Date value
     * @param string $contract_End_Date
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setContract_End_Date($contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date) && !is_string($contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date, true), gettype($contract_End_Date)), __LINE__);
        }
        $this->Contract_End_Date = $contract_End_Date;
        return $this;
    }
    /**
     * Get Date_Placed_in_Service value
     * @return string|null
     */
    public function getDate_Placed_in_Service()
    {
        return $this->Date_Placed_in_Service;
    }
    /**
     * Set Date_Placed_in_Service value
     * @param string $date_Placed_in_Service
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDate_Placed_in_Service($date_Placed_in_Service = null)
    {
        // validation for constraint: string
        if (!is_null($date_Placed_in_Service) && !is_string($date_Placed_in_Service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Placed_in_Service, true), gettype($date_Placed_in_Service)), __LINE__);
        }
        $this->Date_Placed_in_Service = $date_Placed_in_Service;
        return $this;
    }
    /**
     * Get Bonus_Depreciation_Percent value
     * @return float|null
     */
    public function getBonus_Depreciation_Percent()
    {
        return $this->Bonus_Depreciation_Percent;
    }
    /**
     * Set Bonus_Depreciation_Percent value
     * @param float $bonus_Depreciation_Percent
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setBonus_Depreciation_Percent($bonus_Depreciation_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($bonus_Depreciation_Percent) && !(is_float($bonus_Depreciation_Percent) || is_numeric($bonus_Depreciation_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonus_Depreciation_Percent, true), gettype($bonus_Depreciation_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bonus_Depreciation_Percent) && mb_strlen(mb_substr($bonus_Depreciation_Percent, false !== mb_strpos($bonus_Depreciation_Percent, '.') ? mb_strpos($bonus_Depreciation_Percent, '.') + 1 : mb_strlen($bonus_Depreciation_Percent))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bonus_Depreciation_Percent, true), mb_strlen(mb_substr($bonus_Depreciation_Percent, mb_strpos($bonus_Depreciation_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bonus_Depreciation_Percent) && $bonus_Depreciation_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bonus_Depreciation_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($bonus_Depreciation_Percent) && mb_strlen(preg_replace('/(\D)/', '', $bonus_Depreciation_Percent)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($bonus_Depreciation_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $bonus_Depreciation_Percent))), __LINE__);
        }
        $this->Bonus_Depreciation_Percent = $bonus_Depreciation_Percent;
        return $this;
    }
    /**
     * Get Max_Bonus_Depreciable_Basis value
     * @return float|null
     */
    public function getMax_Bonus_Depreciable_Basis()
    {
        return $this->Max_Bonus_Depreciable_Basis;
    }
    /**
     * Set Max_Bonus_Depreciable_Basis value
     * @param float $max_Bonus_Depreciable_Basis
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setMax_Bonus_Depreciable_Basis($max_Bonus_Depreciable_Basis = null)
    {
        // validation for constraint: float
        if (!is_null($max_Bonus_Depreciable_Basis) && !(is_float($max_Bonus_Depreciable_Basis) || is_numeric($max_Bonus_Depreciable_Basis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_Bonus_Depreciable_Basis, true), gettype($max_Bonus_Depreciable_Basis)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($max_Bonus_Depreciable_Basis) && mb_strlen(mb_substr($max_Bonus_Depreciable_Basis, false !== mb_strpos($max_Bonus_Depreciable_Basis, '.') ? mb_strpos($max_Bonus_Depreciable_Basis, '.') + 1 : mb_strlen($max_Bonus_Depreciable_Basis))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($max_Bonus_Depreciable_Basis, true), mb_strlen(mb_substr($max_Bonus_Depreciable_Basis, mb_strpos($max_Bonus_Depreciable_Basis, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($max_Bonus_Depreciable_Basis) && mb_strlen(preg_replace('/(\D)/', '', $max_Bonus_Depreciable_Basis)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($max_Bonus_Depreciable_Basis, true), mb_strlen(preg_replace('/(\D)/', '', $max_Bonus_Depreciable_Basis))), __LINE__);
        }
        $this->Max_Bonus_Depreciable_Basis = $max_Bonus_Depreciable_Basis;
        return $this;
    }
    /**
     * Get Depreciation_Start_Date value
     * @return string|null
     */
    public function getDepreciation_Start_Date()
    {
        return $this->Depreciation_Start_Date;
    }
    /**
     * Set Depreciation_Start_Date value
     * @param string $depreciation_Start_Date
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setDepreciation_Start_Date($depreciation_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($depreciation_Start_Date) && !is_string($depreciation_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depreciation_Start_Date, true), gettype($depreciation_Start_Date)), __LINE__);
        }
        $this->Depreciation_Start_Date = $depreciation_Start_Date;
        return $this;
    }
    /**
     * Get Remaining_Depreciation_Periods value
     * @return float|null
     */
    public function getRemaining_Depreciation_Periods()
    {
        return $this->Remaining_Depreciation_Periods;
    }
    /**
     * Set Remaining_Depreciation_Periods value
     * @param float $remaining_Depreciation_Periods
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setRemaining_Depreciation_Periods($remaining_Depreciation_Periods = null)
    {
        // validation for constraint: float
        if (!is_null($remaining_Depreciation_Periods) && !(is_float($remaining_Depreciation_Periods) || is_numeric($remaining_Depreciation_Periods))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining_Depreciation_Periods, true), gettype($remaining_Depreciation_Periods)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($remaining_Depreciation_Periods) && mb_strlen(mb_substr($remaining_Depreciation_Periods, false !== mb_strpos($remaining_Depreciation_Periods, '.') ? mb_strpos($remaining_Depreciation_Periods, '.') + 1 : mb_strlen($remaining_Depreciation_Periods))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($remaining_Depreciation_Periods, true), mb_strlen(mb_substr($remaining_Depreciation_Periods, mb_strpos($remaining_Depreciation_Periods, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($remaining_Depreciation_Periods) && $remaining_Depreciation_Periods < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($remaining_Depreciation_Periods, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($remaining_Depreciation_Periods) && mb_strlen(preg_replace('/(\D)/', '', $remaining_Depreciation_Periods)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($remaining_Depreciation_Periods, true), mb_strlen(preg_replace('/(\D)/', '', $remaining_Depreciation_Periods))), __LINE__);
        }
        $this->Remaining_Depreciation_Periods = $remaining_Depreciation_Periods;
        return $this;
    }
    /**
     * Get Original_Acquisition_Cost value
     * @return float|null
     */
    public function getOriginal_Acquisition_Cost()
    {
        return $this->Original_Acquisition_Cost;
    }
    /**
     * Set Original_Acquisition_Cost value
     * @param float $original_Acquisition_Cost
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setOriginal_Acquisition_Cost($original_Acquisition_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($original_Acquisition_Cost) && !(is_float($original_Acquisition_Cost) || is_numeric($original_Acquisition_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($original_Acquisition_Cost, true), gettype($original_Acquisition_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($original_Acquisition_Cost) && mb_strlen(mb_substr($original_Acquisition_Cost, false !== mb_strpos($original_Acquisition_Cost, '.') ? mb_strpos($original_Acquisition_Cost, '.') + 1 : mb_strlen($original_Acquisition_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($original_Acquisition_Cost, true), mb_strlen(mb_substr($original_Acquisition_Cost, mb_strpos($original_Acquisition_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($original_Acquisition_Cost) && mb_strlen(preg_replace('/(\D)/', '', $original_Acquisition_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($original_Acquisition_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $original_Acquisition_Cost))), __LINE__);
        }
        $this->Original_Acquisition_Cost = $original_Acquisition_Cost;
        return $this;
    }
    /**
     * Get Total_Asset_Cost value
     * @return float|null
     */
    public function getTotal_Asset_Cost()
    {
        return $this->Total_Asset_Cost;
    }
    /**
     * Set Total_Asset_Cost value
     * @param float $total_Asset_Cost
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setTotal_Asset_Cost($total_Asset_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($total_Asset_Cost) && !(is_float($total_Asset_Cost) || is_numeric($total_Asset_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Asset_Cost, true), gettype($total_Asset_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Asset_Cost) && mb_strlen(mb_substr($total_Asset_Cost, false !== mb_strpos($total_Asset_Cost, '.') ? mb_strpos($total_Asset_Cost, '.') + 1 : mb_strlen($total_Asset_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Asset_Cost, true), mb_strlen(mb_substr($total_Asset_Cost, mb_strpos($total_Asset_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Asset_Cost) && mb_strlen(preg_replace('/(\D)/', '', $total_Asset_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Asset_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $total_Asset_Cost))), __LINE__);
        }
        $this->Total_Asset_Cost = $total_Asset_Cost;
        return $this;
    }
    /**
     * Get Residual_Value value
     * @return float|null
     */
    public function getResidual_Value()
    {
        return $this->Residual_Value;
    }
    /**
     * Set Residual_Value value
     * @param float $residual_Value
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setResidual_Value($residual_Value = null)
    {
        // validation for constraint: float
        if (!is_null($residual_Value) && !(is_float($residual_Value) || is_numeric($residual_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($residual_Value, true), gettype($residual_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($residual_Value) && mb_strlen(mb_substr($residual_Value, false !== mb_strpos($residual_Value, '.') ? mb_strpos($residual_Value, '.') + 1 : mb_strlen($residual_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($residual_Value, true), mb_strlen(mb_substr($residual_Value, mb_strpos($residual_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($residual_Value) && mb_strlen(preg_replace('/(\D)/', '', $residual_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($residual_Value, true), mb_strlen(preg_replace('/(\D)/', '', $residual_Value))), __LINE__);
        }
        $this->Residual_Value = $residual_Value;
        return $this;
    }
    /**
     * Get Fair_Market_Value value
     * @return float|null
     */
    public function getFair_Market_Value()
    {
        return $this->Fair_Market_Value;
    }
    /**
     * Set Fair_Market_Value value
     * @param float $fair_Market_Value
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setFair_Market_Value($fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($fair_Market_Value) && !(is_float($fair_Market_Value) || is_numeric($fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fair_Market_Value, true), gettype($fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($fair_Market_Value) && mb_strlen(mb_substr($fair_Market_Value, false !== mb_strpos($fair_Market_Value, '.') ? mb_strpos($fair_Market_Value, '.') + 1 : mb_strlen($fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($fair_Market_Value, true), mb_strlen(mb_substr($fair_Market_Value, mb_strpos($fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $fair_Market_Value))), __LINE__);
        }
        $this->Fair_Market_Value = $fair_Market_Value;
        return $this;
    }
    /**
     * Get Accumulated_Depreciation value
     * @return float|null
     */
    public function getAccumulated_Depreciation()
    {
        return $this->Accumulated_Depreciation;
    }
    /**
     * Set Accumulated_Depreciation value
     * @param float $accumulated_Depreciation
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAccumulated_Depreciation($accumulated_Depreciation = null)
    {
        // validation for constraint: float
        if (!is_null($accumulated_Depreciation) && !(is_float($accumulated_Depreciation) || is_numeric($accumulated_Depreciation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accumulated_Depreciation, true), gettype($accumulated_Depreciation)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($accumulated_Depreciation) && mb_strlen(mb_substr($accumulated_Depreciation, false !== mb_strpos($accumulated_Depreciation, '.') ? mb_strpos($accumulated_Depreciation, '.') + 1 : mb_strlen($accumulated_Depreciation))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($accumulated_Depreciation, true), mb_strlen(mb_substr($accumulated_Depreciation, mb_strpos($accumulated_Depreciation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($accumulated_Depreciation) && mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($accumulated_Depreciation, true), mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation))), __LINE__);
        }
        $this->Accumulated_Depreciation = $accumulated_Depreciation;
        return $this;
    }
    /**
     * Get Year_to_Date_Depreciation value
     * @return float|null
     */
    public function getYear_to_Date_Depreciation()
    {
        return $this->Year_to_Date_Depreciation;
    }
    /**
     * Set Year_to_Date_Depreciation value
     * @param float $year_to_Date_Depreciation
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setYear_to_Date_Depreciation($year_to_Date_Depreciation = null)
    {
        // validation for constraint: float
        if (!is_null($year_to_Date_Depreciation) && !(is_float($year_to_Date_Depreciation) || is_numeric($year_to_Date_Depreciation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($year_to_Date_Depreciation, true), gettype($year_to_Date_Depreciation)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($year_to_Date_Depreciation) && mb_strlen(mb_substr($year_to_Date_Depreciation, false !== mb_strpos($year_to_Date_Depreciation, '.') ? mb_strpos($year_to_Date_Depreciation, '.') + 1 : mb_strlen($year_to_Date_Depreciation))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($year_to_Date_Depreciation, true), mb_strlen(mb_substr($year_to_Date_Depreciation, mb_strpos($year_to_Date_Depreciation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($year_to_Date_Depreciation) && mb_strlen(preg_replace('/(\D)/', '', $year_to_Date_Depreciation)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($year_to_Date_Depreciation, true), mb_strlen(preg_replace('/(\D)/', '', $year_to_Date_Depreciation))), __LINE__);
        }
        $this->Year_to_Date_Depreciation = $year_to_Date_Depreciation;
        return $this;
    }
    /**
     * Get Historical_Bonus_Depreciation value
     * @return float|null
     */
    public function getHistorical_Bonus_Depreciation()
    {
        return $this->Historical_Bonus_Depreciation;
    }
    /**
     * Set Historical_Bonus_Depreciation value
     * @param float $historical_Bonus_Depreciation
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setHistorical_Bonus_Depreciation($historical_Bonus_Depreciation = null)
    {
        // validation for constraint: float
        if (!is_null($historical_Bonus_Depreciation) && !(is_float($historical_Bonus_Depreciation) || is_numeric($historical_Bonus_Depreciation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($historical_Bonus_Depreciation, true), gettype($historical_Bonus_Depreciation)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($historical_Bonus_Depreciation) && mb_strlen(mb_substr($historical_Bonus_Depreciation, false !== mb_strpos($historical_Bonus_Depreciation, '.') ? mb_strpos($historical_Bonus_Depreciation, '.') + 1 : mb_strlen($historical_Bonus_Depreciation))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($historical_Bonus_Depreciation, true), mb_strlen(mb_substr($historical_Bonus_Depreciation, mb_strpos($historical_Bonus_Depreciation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($historical_Bonus_Depreciation) && mb_strlen(preg_replace('/(\D)/', '', $historical_Bonus_Depreciation)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($historical_Bonus_Depreciation, true), mb_strlen(preg_replace('/(\D)/', '', $historical_Bonus_Depreciation))), __LINE__);
        }
        $this->Historical_Bonus_Depreciation = $historical_Bonus_Depreciation;
        return $this;
    }
    /**
     * Get Asset_Book_Configuration_Additional_Data value
     * @return \StructType\Asset_Depreciation_Schedule_Additional_InformationType|null
     */
    public function getAsset_Book_Configuration_Additional_Data()
    {
        return $this->Asset_Book_Configuration_Additional_Data;
    }
    /**
     * Set Asset_Book_Configuration_Additional_Data value
     * @param \StructType\Asset_Depreciation_Schedule_Additional_InformationType $asset_Book_Configuration_Additional_Data
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAsset_Book_Configuration_Additional_Data(\StructType\Asset_Depreciation_Schedule_Additional_InformationType $asset_Book_Configuration_Additional_Data = null)
    {
        $this->Asset_Book_Configuration_Additional_Data = $asset_Book_Configuration_Additional_Data;
        return $this;
    }
    /**
     * Get Asset_Data value
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType|null
     */
    public function getAsset_Data()
    {
        return $this->Asset_Data;
    }
    /**
     * Set Asset_Data value
     * @param \StructType\Asset_for_Depreciation_Schedule_DataType $asset_Data
     * @return \StructType\Asset_Depreciation_Schedule_DataType
     */
    public function setAsset_Data(\StructType\Asset_for_Depreciation_Schedule_DataType $asset_Data = null)
    {
        $this->Asset_Data = $asset_Data;
        return $this;
    }
}
