<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Rule_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Put Asset Book Rules web service cannot be used to edit an existing rule; it can only add rules, or replace all rules. | Element containing asset book rule replacement data
 * @subpackage Structs
 */
class Asset_Book_Rule_Replacement_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique reference identifier to the set of asset book rules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Asset_Book_Rule_Order
     * Meta information extracted from the WSDL
     * - documentation: Used to define the order of the rules (ascending).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Book_Rule_Order;
    /**
     * The Spend_Category_or_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing spend categories or spend category hierarchies to which the asset book rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_or_Hierarchy_Reference;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing asset classes to which the asset book rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType[]
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing asset types to which the asset book rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType[]
     */
    public $Asset_Type_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing companies or company hierarchies to which the asset book rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing currency to which the asset book rule applies. This is required if Greater than Amount is specified.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Amount_Threshold
     * Meta information extracted from the WSDL
     * - documentation: The amount above which the asset book rule applies.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount_Threshold;
    /**
     * The Amount_Basis_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to UNIT or EXTENDED Amount basis reference. This is required when specifying 'Greater Than Amount'.
     * - minOccurs: 0
     * @var \StructType\Business_Asset_Amount_BasisObjectType
     */
    public $Amount_Basis_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the resulting accounting treatment for the asset book rule.
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Depreciation_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the resulting depreciation profile for the asset book rule.
     * - minOccurs: 0
     * @var \StructType\Depreciation_ProfileObjectType
     */
    public $Depreciation_Profile_Reference;
    /**
     * Constructor method for Asset_Book_Rule_Replacement_DataType
     * @uses Asset_Book_Rule_Replacement_DataType::setID()
     * @uses Asset_Book_Rule_Replacement_DataType::setAsset_Book_Rule_Order()
     * @uses Asset_Book_Rule_Replacement_DataType::setSpend_Category_or_Hierarchy_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setAsset_Class_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setAsset_Type_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setCompany_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setCurrency_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setAmount_Threshold()
     * @uses Asset_Book_Rule_Replacement_DataType::setAmount_Basis_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setAccounting_Treatment_Reference()
     * @uses Asset_Book_Rule_Replacement_DataType::setDepreciation_Profile_Reference()
     * @param string $iD
     * @param string $asset_Book_Rule_Order
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @param \StructType\Asset_ClassObjectType[] $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType[] $asset_Type_Reference
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $amount_Threshold
     * @param \StructType\Business_Asset_Amount_BasisObjectType $amount_Basis_Reference
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     */
    public function __construct($iD = null, $asset_Book_Rule_Order = null, array $spend_Category_or_Hierarchy_Reference = array(), array $asset_Class_Reference = array(), array $asset_Type_Reference = array(), array $company_Reference = array(), \StructType\CurrencyObjectType $currency_Reference = null, $amount_Threshold = null, \StructType\Business_Asset_Amount_BasisObjectType $amount_Basis_Reference = null, \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null)
    {
        $this
            ->setID($iD)
            ->setAsset_Book_Rule_Order($asset_Book_Rule_Order)
            ->setSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setCompany_Reference($company_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setAmount_Threshold($amount_Threshold)
            ->setAmount_Basis_Reference($amount_Basis_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setDepreciation_Profile_Reference($depreciation_Profile_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Asset_Book_Rule_Order value
     * @return string|null
     */
    public function getAsset_Book_Rule_Order()
    {
        return $this->Asset_Book_Rule_Order;
    }
    /**
     * Set Asset_Book_Rule_Order value
     * @param string $asset_Book_Rule_Order
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setAsset_Book_Rule_Order($asset_Book_Rule_Order = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Book_Rule_Order) && !is_string($asset_Book_Rule_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Book_Rule_Order, true), gettype($asset_Book_Rule_Order)), __LINE__);
        }
        $this->Asset_Book_Rule_Order = $asset_Book_Rule_Order;
        return $this;
    }
    /**
     * Get Spend_Category_or_Hierarchy_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_or_Hierarchy_Reference()
    {
        return $this->Spend_Category_or_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_or_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_or_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($asset_Book_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) ? get_class($asset_Book_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem), var_export($asset_Book_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setSpend_Category_or_Hierarchy_Reference(array $spend_Category_or_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage = self::validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference = $spend_Category_or_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function addToSpend_Category_or_Hierarchy_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType[]|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Class_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Class_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Class_ReferenceForArrayConstraintsFromSetAsset_Class_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Rule_Replacement_DataTypeAsset_Class_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Rule_Replacement_DataTypeAsset_Class_ReferenceItem instanceof \StructType\Asset_ClassObjectType) {
                $invalidValues[] = is_object($asset_Book_Rule_Replacement_DataTypeAsset_Class_ReferenceItem) ? get_class($asset_Book_Rule_Replacement_DataTypeAsset_Class_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Rule_Replacement_DataTypeAsset_Class_ReferenceItem), var_export($asset_Book_Rule_Replacement_DataTypeAsset_Class_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Class_Reference property can only contain items of type \StructType\Asset_ClassObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Class_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_ClassObjectType[] $asset_Class_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setAsset_Class_Reference(array $asset_Class_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Class_ReferenceArrayErrorMessage = self::validateAsset_Class_ReferenceForArrayConstraintsFromSetAsset_Class_Reference($asset_Class_Reference))) {
            throw new \InvalidArgumentException($asset_Class_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Class_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_ClassObjectType $item
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function addToAsset_Class_Reference(\StructType\Asset_ClassObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_ClassObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Class_Reference property can only contain items of type \StructType\Asset_ClassObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Class_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType[]|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Type_ReferenceForArrayConstraintsFromSetAsset_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Rule_Replacement_DataTypeAsset_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Rule_Replacement_DataTypeAsset_Type_ReferenceItem instanceof \StructType\Asset_TypeObjectType) {
                $invalidValues[] = is_object($asset_Book_Rule_Replacement_DataTypeAsset_Type_ReferenceItem) ? get_class($asset_Book_Rule_Replacement_DataTypeAsset_Type_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Rule_Replacement_DataTypeAsset_Type_ReferenceItem), var_export($asset_Book_Rule_Replacement_DataTypeAsset_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Type_Reference property can only contain items of type \StructType\Asset_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_TypeObjectType[] $asset_Type_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setAsset_Type_Reference(array $asset_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Type_ReferenceArrayErrorMessage = self::validateAsset_Type_ReferenceForArrayConstraintsFromSetAsset_Type_Reference($asset_Type_Reference))) {
            throw new \InvalidArgumentException($asset_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_TypeObjectType $item
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function addToAsset_Type_Reference(\StructType\Asset_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Type_Reference property can only contain items of type \StructType\Asset_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Rule_Replacement_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Rule_Replacement_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($asset_Book_Rule_Replacement_DataTypeCompany_ReferenceItem) ? get_class($asset_Book_Rule_Replacement_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Rule_Replacement_DataTypeCompany_ReferenceItem), var_export($asset_Book_Rule_Replacement_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Amount_Threshold value
     * @return float|null
     */
    public function getAmount_Threshold()
    {
        return $this->Amount_Threshold;
    }
    /**
     * Set Amount_Threshold value
     * @param float $amount_Threshold
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setAmount_Threshold($amount_Threshold = null)
    {
        // validation for constraint: float
        if (!is_null($amount_Threshold) && !(is_float($amount_Threshold) || is_numeric($amount_Threshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_Threshold, true), gettype($amount_Threshold)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount_Threshold) && mb_strlen(mb_substr($amount_Threshold, false !== mb_strpos($amount_Threshold, '.') ? mb_strpos($amount_Threshold, '.') + 1 : mb_strlen($amount_Threshold))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount_Threshold, true), mb_strlen(mb_substr($amount_Threshold, mb_strpos($amount_Threshold, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount_Threshold) && mb_strlen(preg_replace('/(\D)/', '', $amount_Threshold)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount_Threshold, true), mb_strlen(preg_replace('/(\D)/', '', $amount_Threshold))), __LINE__);
        }
        $this->Amount_Threshold = $amount_Threshold;
        return $this;
    }
    /**
     * Get Amount_Basis_Reference value
     * @return \StructType\Business_Asset_Amount_BasisObjectType|null
     */
    public function getAmount_Basis_Reference()
    {
        return $this->Amount_Basis_Reference;
    }
    /**
     * Set Amount_Basis_Reference value
     * @param \StructType\Business_Asset_Amount_BasisObjectType $amount_Basis_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setAmount_Basis_Reference(\StructType\Business_Asset_Amount_BasisObjectType $amount_Basis_Reference = null)
    {
        $this->Amount_Basis_Reference = $amount_Basis_Reference;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Profile_Reference value
     * @return \StructType\Depreciation_ProfileObjectType|null
     */
    public function getDepreciation_Profile_Reference()
    {
        return $this->Depreciation_Profile_Reference;
    }
    /**
     * Set Depreciation_Profile_Reference value
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @return \StructType\Asset_Book_Rule_Replacement_DataType
     */
    public function setDepreciation_Profile_Reference(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null)
    {
        $this->Depreciation_Profile_Reference = $depreciation_Profile_Reference;
        return $this;
    }
}
