<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Travel_Profile_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Worker Travel Profile records
 * @subpackage Structs
 */
class Worker_Travel_Profile_WWSType extends AbstractStructBase
{
    /**
     * The Worker_Travel_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Worker Travel Profile Listing File for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Worker_Travel_Profile_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker Reference
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airline Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType[]
     */
    public $Airline_Reference;
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Business Asset Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType[]
     */
    public $Business_Asset_Reference;
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hotel Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelObjectType[]
     */
    public $Hotel_Reference;
    /**
     * The Travel_Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel Country Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CountryObjectType[]
     */
    public $Travel_Country_Reference;
    /**
     * The Vehicle_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Vehicle Type Reference
     * - minOccurs: 0
     * @var \StructType\Vehicle_TypeObjectType
     */
    public $Vehicle_Type_Reference;
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Car Rental Agency Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Car_Rental_AgencyObjectType[]
     */
    public $Car_Rental_Agency_Reference;
    /**
     * The Fuel_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Fuel Type Reference
     * - minOccurs: 0
     * @var \StructType\Fuel_TypeObjectType
     */
    public $Fuel_Type_Reference;
    /**
     * The Engine_Capacity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Engine Capacity Reference
     * - minOccurs: 0
     * @var \StructType\Engine_CapacityObjectType
     */
    public $Engine_Capacity_Reference;
    /**
     * The Vehicle_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Vehicle Plan Reference
     * - minOccurs: 0
     * @var \StructType\Vehicle_PlanObjectType
     */
    public $Vehicle_Plan_Reference;
    /**
     * The Expense_Item_Accumulator_Balance_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Accumulator_Balance_DataType[]
     */
    public $Expense_Item_Accumulator_Balance_Data;
    /**
     * Constructor method for Worker_Travel_Profile_WWSType
     * @uses Worker_Travel_Profile_WWSType::setWorker_Travel_Profile_Reference()
     * @uses Worker_Travel_Profile_WWSType::setWorker_Reference()
     * @uses Worker_Travel_Profile_WWSType::setAirline_Reference()
     * @uses Worker_Travel_Profile_WWSType::setBusiness_Asset_Reference()
     * @uses Worker_Travel_Profile_WWSType::setHotel_Reference()
     * @uses Worker_Travel_Profile_WWSType::setTravel_Country_Reference()
     * @uses Worker_Travel_Profile_WWSType::setVehicle_Type_Reference()
     * @uses Worker_Travel_Profile_WWSType::setCar_Rental_Agency_Reference()
     * @uses Worker_Travel_Profile_WWSType::setFuel_Type_Reference()
     * @uses Worker_Travel_Profile_WWSType::setEngine_Capacity_Reference()
     * @uses Worker_Travel_Profile_WWSType::setVehicle_Plan_Reference()
     * @uses Worker_Travel_Profile_WWSType::setExpense_Item_Accumulator_Balance_Data()
     * @param \StructType\Unique_IdentifierObjectType $worker_Travel_Profile_Reference
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @param \StructType\Business_AssetObjectType[] $business_Asset_Reference
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @param \StructType\CountryObjectType[] $travel_Country_Reference
     * @param \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @param \StructType\Fuel_TypeObjectType $fuel_Type_Reference
     * @param \StructType\Engine_CapacityObjectType $engine_Capacity_Reference
     * @param \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference
     * @param \StructType\Expense_Item_Accumulator_Balance_DataType[] $expense_Item_Accumulator_Balance_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $worker_Travel_Profile_Reference = null, \StructType\WorkerObjectType $worker_Reference = null, array $airline_Reference = array(), array $business_Asset_Reference = array(), array $hotel_Reference = array(), array $travel_Country_Reference = array(), \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference = null, array $car_Rental_Agency_Reference = array(), \StructType\Fuel_TypeObjectType $fuel_Type_Reference = null, \StructType\Engine_CapacityObjectType $engine_Capacity_Reference = null, \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference = null, array $expense_Item_Accumulator_Balance_Data = array())
    {
        $this
            ->setWorker_Travel_Profile_Reference($worker_Travel_Profile_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setAirline_Reference($airline_Reference)
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setHotel_Reference($hotel_Reference)
            ->setTravel_Country_Reference($travel_Country_Reference)
            ->setVehicle_Type_Reference($vehicle_Type_Reference)
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference)
            ->setFuel_Type_Reference($fuel_Type_Reference)
            ->setEngine_Capacity_Reference($engine_Capacity_Reference)
            ->setVehicle_Plan_Reference($vehicle_Plan_Reference)
            ->setExpense_Item_Accumulator_Balance_Data($expense_Item_Accumulator_Balance_Data);
    }
    /**
     * Get Worker_Travel_Profile_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getWorker_Travel_Profile_Reference()
    {
        return $this->Worker_Travel_Profile_Reference;
    }
    /**
     * Set Worker_Travel_Profile_Reference value
     * @param \StructType\Unique_IdentifierObjectType $worker_Travel_Profile_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setWorker_Travel_Profile_Reference(\StructType\Unique_IdentifierObjectType $worker_Travel_Profile_Reference = null)
    {
        $this->Worker_Travel_Profile_Reference = $worker_Travel_Profile_Reference;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType[]|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_WWSTypeAirline_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_WWSTypeAirline_ReferenceItem instanceof \StructType\AirlineObjectType) {
                $invalidValues[] = is_object($worker_Travel_Profile_WWSTypeAirline_ReferenceItem) ? get_class($worker_Travel_Profile_WWSTypeAirline_ReferenceItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_WWSTypeAirline_ReferenceItem), var_export($worker_Travel_Profile_WWSTypeAirline_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setAirline_Reference(array $airline_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($airline_ReferenceArrayErrorMessage = self::validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference($airline_Reference))) {
            throw new \InvalidArgumentException($airline_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Add item to Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType $item
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function addToAirline_Reference(\StructType\AirlineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline_Reference[] = $item;
        return $this;
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType[]|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Asset_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Asset_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Asset_ReferenceForArrayConstraintsFromSetBusiness_Asset_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_WWSTypeBusiness_Asset_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_WWSTypeBusiness_Asset_ReferenceItem instanceof \StructType\Business_AssetObjectType) {
                $invalidValues[] = is_object($worker_Travel_Profile_WWSTypeBusiness_Asset_ReferenceItem) ? get_class($worker_Travel_Profile_WWSTypeBusiness_Asset_ReferenceItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_WWSTypeBusiness_Asset_ReferenceItem), var_export($worker_Travel_Profile_WWSTypeBusiness_Asset_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Asset_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Asset_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType[] $business_Asset_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setBusiness_Asset_Reference(array $business_Asset_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Asset_ReferenceArrayErrorMessage = self::validateBusiness_Asset_ReferenceForArrayConstraintsFromSetBusiness_Asset_Reference($business_Asset_Reference))) {
            throw new \InvalidArgumentException($business_Asset_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Add item to Business_Asset_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType $item
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function addToBusiness_Asset_Reference(\StructType\Business_AssetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_AssetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Business_Asset_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Asset_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType[]|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_WWSTypeHotel_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_WWSTypeHotel_ReferenceItem instanceof \StructType\HotelObjectType) {
                $invalidValues[] = is_object($worker_Travel_Profile_WWSTypeHotel_ReferenceItem) ? get_class($worker_Travel_Profile_WWSTypeHotel_ReferenceItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_WWSTypeHotel_ReferenceItem), var_export($worker_Travel_Profile_WWSTypeHotel_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setHotel_Reference(array $hotel_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($hotel_ReferenceArrayErrorMessage = self::validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference($hotel_Reference))) {
            throw new \InvalidArgumentException($hotel_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Add item to Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType $item
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function addToHotel_Reference(\StructType\HotelObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelObjectType) {
            throw new \InvalidArgumentException(sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel_Reference[] = $item;
        return $this;
    }
    /**
     * Get Travel_Country_Reference value
     * @return \StructType\CountryObjectType[]|null
     */
    public function getTravel_Country_Reference()
    {
        return $this->Travel_Country_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Country_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Country_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Country_ReferenceForArrayConstraintsFromSetTravel_Country_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_WWSTypeTravel_Country_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_WWSTypeTravel_Country_ReferenceItem instanceof \StructType\CountryObjectType) {
                $invalidValues[] = is_object($worker_Travel_Profile_WWSTypeTravel_Country_ReferenceItem) ? get_class($worker_Travel_Profile_WWSTypeTravel_Country_ReferenceItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_WWSTypeTravel_Country_ReferenceItem), var_export($worker_Travel_Profile_WWSTypeTravel_Country_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Country_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Country_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType[] $travel_Country_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setTravel_Country_Reference(array $travel_Country_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Country_ReferenceArrayErrorMessage = self::validateTravel_Country_ReferenceForArrayConstraintsFromSetTravel_Country_Reference($travel_Country_Reference))) {
            throw new \InvalidArgumentException($travel_Country_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_Country_Reference = $travel_Country_Reference;
        return $this;
    }
    /**
     * Add item to Travel_Country_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType $item
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function addToTravel_Country_Reference(\StructType\CountryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Country_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Country_Reference[] = $item;
        return $this;
    }
    /**
     * Get Vehicle_Type_Reference value
     * @return \StructType\Vehicle_TypeObjectType|null
     */
    public function getVehicle_Type_Reference()
    {
        return $this->Vehicle_Type_Reference;
    }
    /**
     * Set Vehicle_Type_Reference value
     * @param \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setVehicle_Type_Reference(\StructType\Vehicle_TypeObjectType $vehicle_Type_Reference = null)
    {
        $this->Vehicle_Type_Reference = $vehicle_Type_Reference;
        return $this;
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType[]|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCar_Rental_Agency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCar_Rental_Agency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_WWSTypeCar_Rental_Agency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_WWSTypeCar_Rental_Agency_ReferenceItem instanceof \StructType\Car_Rental_AgencyObjectType) {
                $invalidValues[] = is_object($worker_Travel_Profile_WWSTypeCar_Rental_Agency_ReferenceItem) ? get_class($worker_Travel_Profile_WWSTypeCar_Rental_Agency_ReferenceItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_WWSTypeCar_Rental_Agency_ReferenceItem), var_export($worker_Travel_Profile_WWSTypeCar_Rental_Agency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setCar_Rental_Agency_Reference(array $car_Rental_Agency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($car_Rental_Agency_ReferenceArrayErrorMessage = self::validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference($car_Rental_Agency_Reference))) {
            throw new \InvalidArgumentException($car_Rental_Agency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Add item to Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType $item
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function addToCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Car_Rental_AgencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Car_Rental_Agency_Reference[] = $item;
        return $this;
    }
    /**
     * Get Fuel_Type_Reference value
     * @return \StructType\Fuel_TypeObjectType|null
     */
    public function getFuel_Type_Reference()
    {
        return $this->Fuel_Type_Reference;
    }
    /**
     * Set Fuel_Type_Reference value
     * @param \StructType\Fuel_TypeObjectType $fuel_Type_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setFuel_Type_Reference(\StructType\Fuel_TypeObjectType $fuel_Type_Reference = null)
    {
        $this->Fuel_Type_Reference = $fuel_Type_Reference;
        return $this;
    }
    /**
     * Get Engine_Capacity_Reference value
     * @return \StructType\Engine_CapacityObjectType|null
     */
    public function getEngine_Capacity_Reference()
    {
        return $this->Engine_Capacity_Reference;
    }
    /**
     * Set Engine_Capacity_Reference value
     * @param \StructType\Engine_CapacityObjectType $engine_Capacity_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setEngine_Capacity_Reference(\StructType\Engine_CapacityObjectType $engine_Capacity_Reference = null)
    {
        $this->Engine_Capacity_Reference = $engine_Capacity_Reference;
        return $this;
    }
    /**
     * Get Vehicle_Plan_Reference value
     * @return \StructType\Vehicle_PlanObjectType|null
     */
    public function getVehicle_Plan_Reference()
    {
        return $this->Vehicle_Plan_Reference;
    }
    /**
     * Set Vehicle_Plan_Reference value
     * @param \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setVehicle_Plan_Reference(\StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference = null)
    {
        $this->Vehicle_Plan_Reference = $vehicle_Plan_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Accumulator_Balance_Data value
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType[]|null
     */
    public function getExpense_Item_Accumulator_Balance_Data()
    {
        return $this->Expense_Item_Accumulator_Balance_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Accumulator_Balance_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Accumulator_Balance_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_Accumulator_Balance_DataForArrayConstraintsFromSetExpense_Item_Accumulator_Balance_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_WWSTypeExpense_Item_Accumulator_Balance_DataItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_WWSTypeExpense_Item_Accumulator_Balance_DataItem instanceof \StructType\Expense_Item_Accumulator_Balance_DataType) {
                $invalidValues[] = is_object($worker_Travel_Profile_WWSTypeExpense_Item_Accumulator_Balance_DataItem) ? get_class($worker_Travel_Profile_WWSTypeExpense_Item_Accumulator_Balance_DataItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_WWSTypeExpense_Item_Accumulator_Balance_DataItem), var_export($worker_Travel_Profile_WWSTypeExpense_Item_Accumulator_Balance_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Accumulator_Balance_Data property can only contain items of type \StructType\Expense_Item_Accumulator_Balance_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Accumulator_Balance_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Accumulator_Balance_DataType[] $expense_Item_Accumulator_Balance_Data
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function setExpense_Item_Accumulator_Balance_Data(array $expense_Item_Accumulator_Balance_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_Accumulator_Balance_DataArrayErrorMessage = self::validateExpense_Item_Accumulator_Balance_DataForArrayConstraintsFromSetExpense_Item_Accumulator_Balance_Data($expense_Item_Accumulator_Balance_Data))) {
            throw new \InvalidArgumentException($expense_Item_Accumulator_Balance_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Accumulator_Balance_Data = $expense_Item_Accumulator_Balance_Data;
        return $this;
    }
    /**
     * Add item to Expense_Item_Accumulator_Balance_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Accumulator_Balance_DataType $item
     * @return \StructType\Worker_Travel_Profile_WWSType
     */
    public function addToExpense_Item_Accumulator_Balance_Data(\StructType\Expense_Item_Accumulator_Balance_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Item_Accumulator_Balance_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Accumulator_Balance_Data property can only contain items of type \StructType\Expense_Item_Accumulator_Balance_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Accumulator_Balance_Data[] = $item;
        return $this;
    }
}
