<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing Supplier Item Request Criteria
 * @subpackage Structs
 */
class Supplier_Item_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve supplier items specific to these Purchase Items. If empty, no restriction is applied
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType[]
     */
    public $Purchase_Item_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve supplier items specific to these Suppliers. Important: For integration systems where we want to limit updates to only a single supplier, the Supplier field should be singular and defaulted by the integration system to
     * only be the exact supplier that the user has permission to get pricing information. If empty, no supplier restriction is applied. Suppliers in the list cannot be for a supplier that can be used as a basic worktag only
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve supplier items specific to these Supplier Contracts. Important: For integration systems where we want to limit updates to only a single supplier contract, the Supplier Contract field should be singular and defaulted by
     * the integration system to only be the exact supplier contract that the user has permission to get pricing information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Supplier_Contract_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve supplier items specific to these Spend Categories. If empty, no restriction is applied
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Only_Default_UOM_and_Price
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve pricing information from the default unit of measure (bulk and just in time defaults). If empty or false, all pricing information is retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Only_Default_UOM_and_Price;
    /**
     * The Only_Active_Supplier_Items
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve Supplier Items considered active (that have active unit of measure pricing information.)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Only_Active_Supplier_Items;
    /**
     * The Only_Default_UOMs_with_Calculate_Price_Enabled
     * Meta information extracted from the WSDL
     * - documentation: Return default units of measure when you enable Calculate Price based on Conversion Factor. When you don't enable Calculate Price based on Conversion Factor, we return all Ordering and Just in Time UOMs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Only_Default_UOMs_with_Calculate_Price_Enabled;
    /**
     * The Exclude_Pricing_Calculated_by_Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: Select to exclude pricing that’s calculated based on the conversion factor. When you enable Calculate Price based on Conversion Factor, Workday only returns pricing that is not calculated based on the conversion factor and the also
     * the default price. This enables you to quickly view and edit relevant pricing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Pricing_Calculated_by_Conversion_Factor;
    /**
     * Constructor method for Supplier_Item_Request_CriteriaType
     * @uses Supplier_Item_Request_CriteriaType::setPurchase_Item_Reference()
     * @uses Supplier_Item_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Item_Request_CriteriaType::setSupplier_Contract_Reference()
     * @uses Supplier_Item_Request_CriteriaType::setSpend_Category_Reference()
     * @uses Supplier_Item_Request_CriteriaType::setOnly_Default_UOM_and_Price()
     * @uses Supplier_Item_Request_CriteriaType::setOnly_Active_Supplier_Items()
     * @uses Supplier_Item_Request_CriteriaType::setOnly_Default_UOMs_with_Calculate_Price_Enabled()
     * @uses Supplier_Item_Request_CriteriaType::setExclude_Pricing_Calculated_by_Conversion_Factor()
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @param bool $only_Default_UOM_and_Price
     * @param bool $only_Active_Supplier_Items
     * @param bool $only_Default_UOMs_with_Calculate_Price_Enabled
     * @param bool $exclude_Pricing_Calculated_by_Conversion_Factor
     */
    public function __construct(array $purchase_Item_Reference = array(), array $supplier_Reference = array(), array $supplier_Contract_Reference = array(), array $spend_Category_Reference = array(), $only_Default_UOM_and_Price = null, $only_Active_Supplier_Items = null, $only_Default_UOMs_with_Calculate_Price_Enabled = null, $exclude_Pricing_Calculated_by_Conversion_Factor = null)
    {
        $this
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setOnly_Default_UOM_and_Price($only_Default_UOM_and_Price)
            ->setOnly_Active_Supplier_Items($only_Active_Supplier_Items)
            ->setOnly_Default_UOMs_with_Calculate_Price_Enabled($only_Default_UOMs_with_Calculate_Price_Enabled)
            ->setExclude_Pricing_Calculated_by_Conversion_Factor($exclude_Pricing_Calculated_by_Conversion_Factor);
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType[]|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Request_CriteriaTypePurchase_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Request_CriteriaTypePurchase_Item_ReferenceItem instanceof \StructType\Purchase_ItemObjectType) {
                $invalidValues[] = is_object($supplier_Item_Request_CriteriaTypePurchase_Item_ReferenceItem) ? get_class($supplier_Item_Request_CriteriaTypePurchase_Item_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Request_CriteriaTypePurchase_Item_ReferenceItem), var_export($supplier_Item_Request_CriteriaTypePurchase_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setPurchase_Item_Reference(array $purchase_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_ReferenceArrayErrorMessage = self::validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference($purchase_Item_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType $item
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function addToPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($supplier_Item_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Item_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Item_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($supplier_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem) ? get_class($supplier_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem), var_export($supplier_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setSupplier_Contract_Reference(array $supplier_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_ReferenceArrayErrorMessage = self::validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference($supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function addToSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Request_CriteriaTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Request_CriteriaTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($supplier_Item_Request_CriteriaTypeSpend_Category_ReferenceItem) ? get_class($supplier_Item_Request_CriteriaTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Request_CriteriaTypeSpend_Category_ReferenceItem), var_export($supplier_Item_Request_CriteriaTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Only_Default_UOM_and_Price value
     * @return bool|null
     */
    public function getOnly_Default_UOM_and_Price()
    {
        return $this->Only_Default_UOM_and_Price;
    }
    /**
     * Set Only_Default_UOM_and_Price value
     * @param bool $only_Default_UOM_and_Price
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setOnly_Default_UOM_and_Price($only_Default_UOM_and_Price = null)
    {
        // validation for constraint: boolean
        if (!is_null($only_Default_UOM_and_Price) && !is_bool($only_Default_UOM_and_Price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($only_Default_UOM_and_Price, true), gettype($only_Default_UOM_and_Price)), __LINE__);
        }
        $this->Only_Default_UOM_and_Price = $only_Default_UOM_and_Price;
        return $this;
    }
    /**
     * Get Only_Active_Supplier_Items value
     * @return bool|null
     */
    public function getOnly_Active_Supplier_Items()
    {
        return $this->Only_Active_Supplier_Items;
    }
    /**
     * Set Only_Active_Supplier_Items value
     * @param bool $only_Active_Supplier_Items
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setOnly_Active_Supplier_Items($only_Active_Supplier_Items = null)
    {
        // validation for constraint: boolean
        if (!is_null($only_Active_Supplier_Items) && !is_bool($only_Active_Supplier_Items)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($only_Active_Supplier_Items, true), gettype($only_Active_Supplier_Items)), __LINE__);
        }
        $this->Only_Active_Supplier_Items = $only_Active_Supplier_Items;
        return $this;
    }
    /**
     * Get Only_Default_UOMs_with_Calculate_Price_Enabled value
     * @return bool|null
     */
    public function getOnly_Default_UOMs_with_Calculate_Price_Enabled()
    {
        return $this->Only_Default_UOMs_with_Calculate_Price_Enabled;
    }
    /**
     * Set Only_Default_UOMs_with_Calculate_Price_Enabled value
     * @param bool $only_Default_UOMs_with_Calculate_Price_Enabled
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setOnly_Default_UOMs_with_Calculate_Price_Enabled($only_Default_UOMs_with_Calculate_Price_Enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($only_Default_UOMs_with_Calculate_Price_Enabled) && !is_bool($only_Default_UOMs_with_Calculate_Price_Enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($only_Default_UOMs_with_Calculate_Price_Enabled, true), gettype($only_Default_UOMs_with_Calculate_Price_Enabled)), __LINE__);
        }
        $this->Only_Default_UOMs_with_Calculate_Price_Enabled = $only_Default_UOMs_with_Calculate_Price_Enabled;
        return $this;
    }
    /**
     * Get Exclude_Pricing_Calculated_by_Conversion_Factor value
     * @return bool|null
     */
    public function getExclude_Pricing_Calculated_by_Conversion_Factor()
    {
        return $this->Exclude_Pricing_Calculated_by_Conversion_Factor;
    }
    /**
     * Set Exclude_Pricing_Calculated_by_Conversion_Factor value
     * @param bool $exclude_Pricing_Calculated_by_Conversion_Factor
     * @return \StructType\Supplier_Item_Request_CriteriaType
     */
    public function setExclude_Pricing_Calculated_by_Conversion_Factor($exclude_Pricing_Calculated_by_Conversion_Factor = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Pricing_Calculated_by_Conversion_Factor) && !is_bool($exclude_Pricing_Calculated_by_Conversion_Factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Pricing_Calculated_by_Conversion_Factor, true), gettype($exclude_Pricing_Calculated_by_Conversion_Factor)), __LINE__);
        }
        $this->Exclude_Pricing_Calculated_by_Conversion_Factor = $exclude_Pricing_Calculated_by_Conversion_Factor;
        return $this;
    }
}
