<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains supplier invoice information for supplier contracts
 * @subpackage Structs
 */
class Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType extends AbstractStructBase
{
    /**
     * The Company_for_Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company for Supplier Invoice Reference
     * @var \StructType\CompanyObjectType
     */
    public $Company_for_Supplier_Invoice_Reference;
    /**
     * The Supplier_for_Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier for Supplier Invoice Reference. This is the Pay To Supplier that will be used as a default when creating Supplier Invoice Schedules.
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_for_Supplier_Invoice_Reference;
    /**
     * The Supplier_Connection_for_Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Business Connection.
     * - choice: Supplier_Connection_for_Supplier_Invoice_Reference | Use_Default_Supplier_Connection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_for_Supplier_Invoice_Reference;
    /**
     * The Use_Default_Supplier_Connection
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the default supplier connection will be derived.
     * - choice: Supplier_Connection_for_Supplier_Invoice_Reference | Use_Default_Supplier_Connection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Default_Supplier_Connection;
    /**
     * The Supplier_Invoice_Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Payment Terms Reference
     * @var \StructType\Payment_TermsObjectType
     */
    public $Supplier_Invoice_Payment_Terms_Reference;
    /**
     * The Scheduled_Invoice_Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The payment type to be used when the default payment from the Supplier is not preferred. This is only acceptable when there are scheduled invoices for this contract type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Scheduled_Invoice_Override_Payment_Type_Reference;
    /**
     * The Supplier_Invoice_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Reference_Number;
    /**
     * Constructor method for
     * Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setCompany_for_Supplier_Invoice_Reference()
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setSupplier_for_Supplier_Invoice_Reference()
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setSupplier_Connection_for_Supplier_Invoice_Reference()
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setUse_Default_Supplier_Connection()
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setSupplier_Invoice_Payment_Terms_Reference()
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setScheduled_Invoice_Override_Payment_Type_Reference()
     * @uses Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType::setSupplier_Invoice_Reference_Number()
     * @param \StructType\CompanyObjectType $company_for_Supplier_Invoice_Reference
     * @param \StructType\SupplierObjectType $supplier_for_Supplier_Invoice_Reference
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_for_Supplier_Invoice_Reference
     * @param bool $use_Default_Supplier_Connection
     * @param \StructType\Payment_TermsObjectType $supplier_Invoice_Payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType $scheduled_Invoice_Override_Payment_Type_Reference
     * @param string $supplier_Invoice_Reference_Number
     */
    public function __construct(\StructType\CompanyObjectType $company_for_Supplier_Invoice_Reference = null, \StructType\SupplierObjectType $supplier_for_Supplier_Invoice_Reference = null, \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_for_Supplier_Invoice_Reference = null, $use_Default_Supplier_Connection = null, \StructType\Payment_TermsObjectType $supplier_Invoice_Payment_Terms_Reference = null, \StructType\Payment_TypeObjectType $scheduled_Invoice_Override_Payment_Type_Reference = null, $supplier_Invoice_Reference_Number = null)
    {
        $this
            ->setCompany_for_Supplier_Invoice_Reference($company_for_Supplier_Invoice_Reference)
            ->setSupplier_for_Supplier_Invoice_Reference($supplier_for_Supplier_Invoice_Reference)
            ->setSupplier_Connection_for_Supplier_Invoice_Reference($supplier_Connection_for_Supplier_Invoice_Reference)
            ->setUse_Default_Supplier_Connection($use_Default_Supplier_Connection)
            ->setSupplier_Invoice_Payment_Terms_Reference($supplier_Invoice_Payment_Terms_Reference)
            ->setScheduled_Invoice_Override_Payment_Type_Reference($scheduled_Invoice_Override_Payment_Type_Reference)
            ->setSupplier_Invoice_Reference_Number($supplier_Invoice_Reference_Number);
    }
    /**
     * Get Company_for_Supplier_Invoice_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_for_Supplier_Invoice_Reference()
    {
        return $this->Company_for_Supplier_Invoice_Reference;
    }
    /**
     * Set Company_for_Supplier_Invoice_Reference value
     * @param \StructType\CompanyObjectType $company_for_Supplier_Invoice_Reference
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setCompany_for_Supplier_Invoice_Reference(\StructType\CompanyObjectType $company_for_Supplier_Invoice_Reference = null)
    {
        $this->Company_for_Supplier_Invoice_Reference = $company_for_Supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Supplier_for_Supplier_Invoice_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_for_Supplier_Invoice_Reference()
    {
        return $this->Supplier_for_Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_for_Supplier_Invoice_Reference value
     * @param \StructType\SupplierObjectType $supplier_for_Supplier_Invoice_Reference
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_for_Supplier_Invoice_Reference(\StructType\SupplierObjectType $supplier_for_Supplier_Invoice_Reference = null)
    {
        $this->Supplier_for_Supplier_Invoice_Reference = $supplier_for_Supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_for_Supplier_Invoice_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_for_Supplier_Invoice_Reference()
    {
        return isset($this->Supplier_Connection_for_Supplier_Invoice_Reference) ? $this->Supplier_Connection_for_Supplier_Invoice_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Connection_for_Supplier_Invoice_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Connection_for_Supplier_Invoice_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Connection_for_Supplier_Invoice_ReferenceForChoiceConstraintsFromSetSupplier_Connection_for_Supplier_Invoice_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Default_Supplier_Connection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Connection_for_Supplier_Invoice_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Connection_for_Supplier_Invoice_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Connection_for_Supplier_Invoice_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_for_Supplier_Invoice_Reference
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Connection_for_Supplier_Invoice_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_for_Supplier_Invoice_Reference = null)
    {
        // validation for constraint: choice(Supplier_Connection_for_Supplier_Invoice_Reference, Use_Default_Supplier_Connection)
        if ('' !== ($supplier_Connection_for_Supplier_Invoice_ReferenceChoiceErrorMessage = self::validateSupplier_Connection_for_Supplier_Invoice_ReferenceForChoiceConstraintsFromSetSupplier_Connection_for_Supplier_Invoice_Reference($supplier_Connection_for_Supplier_Invoice_Reference))) {
            throw new \InvalidArgumentException($supplier_Connection_for_Supplier_Invoice_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Connection_for_Supplier_Invoice_Reference) || (is_array($supplier_Connection_for_Supplier_Invoice_Reference) && empty($supplier_Connection_for_Supplier_Invoice_Reference))) {
            unset($this->Supplier_Connection_for_Supplier_Invoice_Reference);
        } else {
            $this->Supplier_Connection_for_Supplier_Invoice_Reference = $supplier_Connection_for_Supplier_Invoice_Reference;
        }
        return $this;
    }
    /**
     * Get Use_Default_Supplier_Connection value
     * @return bool|null
     */
    public function getUse_Default_Supplier_Connection()
    {
        return isset($this->Use_Default_Supplier_Connection) ? $this->Use_Default_Supplier_Connection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Default_Supplier_Connection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Default_Supplier_Connection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Connection_for_Supplier_Invoice_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Default_Supplier_Connection can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Default_Supplier_Connection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Default_Supplier_Connection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Default_Supplier_Connection
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setUse_Default_Supplier_Connection($use_Default_Supplier_Connection = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Default_Supplier_Connection) && !is_bool($use_Default_Supplier_Connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Default_Supplier_Connection, true), gettype($use_Default_Supplier_Connection)), __LINE__);
        }
        // validation for constraint: choice(Supplier_Connection_for_Supplier_Invoice_Reference, Use_Default_Supplier_Connection)
        if ('' !== ($use_Default_Supplier_ConnectionChoiceErrorMessage = self::validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($use_Default_Supplier_Connection))) {
            throw new \InvalidArgumentException($use_Default_Supplier_ConnectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Default_Supplier_Connection) || (is_array($use_Default_Supplier_Connection) && empty($use_Default_Supplier_Connection))) {
            unset($this->Use_Default_Supplier_Connection);
        } else {
            $this->Use_Default_Supplier_Connection = $use_Default_Supplier_Connection;
        }
        return $this;
    }
    /**
     * Get Supplier_Invoice_Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getSupplier_Invoice_Payment_Terms_Reference()
    {
        return $this->Supplier_Invoice_Payment_Terms_Reference;
    }
    /**
     * Set Supplier_Invoice_Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $supplier_Invoice_Payment_Terms_Reference
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Invoice_Payment_Terms_Reference(\StructType\Payment_TermsObjectType $supplier_Invoice_Payment_Terms_Reference = null)
    {
        $this->Supplier_Invoice_Payment_Terms_Reference = $supplier_Invoice_Payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Scheduled_Invoice_Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getScheduled_Invoice_Override_Payment_Type_Reference()
    {
        return $this->Scheduled_Invoice_Override_Payment_Type_Reference;
    }
    /**
     * Set Scheduled_Invoice_Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $scheduled_Invoice_Override_Payment_Type_Reference
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setScheduled_Invoice_Override_Payment_Type_Reference(\StructType\Payment_TypeObjectType $scheduled_Invoice_Override_Payment_Type_Reference = null)
    {
        $this->Scheduled_Invoice_Override_Payment_Type_Reference = $scheduled_Invoice_Override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Invoice_Reference_Number()
    {
        return $this->Supplier_Invoice_Reference_Number;
    }
    /**
     * Set Supplier_Invoice_Reference_Number value
     * @param string $supplier_Invoice_Reference_Number
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Invoice_Reference_Number($supplier_Invoice_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Reference_Number) && !is_string($supplier_Invoice_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Reference_Number, true), gettype($supplier_Invoice_Reference_Number)), __LINE__);
        }
        $this->Supplier_Invoice_Reference_Number = $supplier_Invoice_Reference_Number;
        return $this;
    }
}
