<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Refund_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element contains Submit Supplier Refund Response Data.
 * @subpackage Structs
 */
class Submit_Supplier_Refund_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Refund_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Refund.
     * - minOccurs: 0
     * @var \StructType\Supplier_RefundObjectType
     */
    public $Supplier_Refund_Reference;
    /**
     * The Supplier_Refund_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Refund Event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Supplier_Refund_Event_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Refund_ResponseType
     * @uses Submit_Supplier_Refund_ResponseType::setSupplier_Refund_Reference()
     * @uses Submit_Supplier_Refund_ResponseType::setSupplier_Refund_Event_Reference()
     * @uses Submit_Supplier_Refund_ResponseType::setVersion()
     * @param \StructType\Supplier_RefundObjectType $supplier_Refund_Reference
     * @param \StructType\Unique_IdentifierObjectType $supplier_Refund_Event_Reference
     * @param string $version
     */
    public function __construct(\StructType\Supplier_RefundObjectType $supplier_Refund_Reference = null, \StructType\Unique_IdentifierObjectType $supplier_Refund_Event_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Refund_Reference($supplier_Refund_Reference)
            ->setSupplier_Refund_Event_Reference($supplier_Refund_Event_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Refund_Reference value
     * @return \StructType\Supplier_RefundObjectType|null
     */
    public function getSupplier_Refund_Reference()
    {
        return $this->Supplier_Refund_Reference;
    }
    /**
     * Set Supplier_Refund_Reference value
     * @param \StructType\Supplier_RefundObjectType $supplier_Refund_Reference
     * @return \StructType\Submit_Supplier_Refund_ResponseType
     */
    public function setSupplier_Refund_Reference(\StructType\Supplier_RefundObjectType $supplier_Refund_Reference = null)
    {
        $this->Supplier_Refund_Reference = $supplier_Refund_Reference;
        return $this;
    }
    /**
     * Get Supplier_Refund_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getSupplier_Refund_Event_Reference()
    {
        return $this->Supplier_Refund_Event_Reference;
    }
    /**
     * Set Supplier_Refund_Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $supplier_Refund_Event_Reference
     * @return \StructType\Submit_Supplier_Refund_ResponseType
     */
    public function setSupplier_Refund_Event_Reference(\StructType\Unique_IdentifierObjectType $supplier_Refund_Event_Reference = null)
    {
        $this->Supplier_Refund_Event_Reference = $supplier_Refund_Event_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Refund_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
