<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Response_Line_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element to capture responses to Request for Quote Lines. It also includes responses to line level bid requirements
 * @subpackage Structs
 */
class RFQ_Response_Line_Data_InboundType extends AbstractStructBase
{
    /**
     * The RFQ_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ Line to which a response is recorded.
     * @var \StructType\Request_for_Quote_LineObjectType
     */
    public $RFQ_Line_Reference;
    /**
     * The No_Bid
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate where bid is made for a RFQ line when submitting the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $No_Bid;
    /**
     * The Response_Line_Description
     * Meta information extracted from the WSDL
     * - documentation: The Response Line Item Description on the RFQ Response Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Line_Description;
    /**
     * The Response_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Response Quantity recorded on RFQ Response Line. | Response Quantity as entered by the supplier..
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Response_Quantity;
    /**
     * The Response_Price
     * Meta information extracted from the WSDL
     * - documentation: Response Price recorded on RFQ Response Line. | Response Price provided by the supplier. | Response Price on RFQ Response Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Response_Price;
    /**
     * The Lead_Time_in_Days
     * Meta information extracted from the WSDL
     * - documentation: Response Lead Time provided by the supplier.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time_in_Days;
    /**
     * The Response_Line_Memo
     * Meta information extracted from the WSDL
     * - documentation: Response Line Memo provided by the supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Line_Memo;
    /**
     * The RFQ_Line_Bid_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[]
     */
    public $RFQ_Line_Bid_Response_Data;
    /**
     * The RFQ_Response_Line_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $RFQ_Response_Line_Attachment_Data;
    /**
     * Constructor method for RFQ_Response_Line_Data_InboundType
     * @uses RFQ_Response_Line_Data_InboundType::setRFQ_Line_Reference()
     * @uses RFQ_Response_Line_Data_InboundType::setNo_Bid()
     * @uses RFQ_Response_Line_Data_InboundType::setResponse_Line_Description()
     * @uses RFQ_Response_Line_Data_InboundType::setResponse_Quantity()
     * @uses RFQ_Response_Line_Data_InboundType::setResponse_Price()
     * @uses RFQ_Response_Line_Data_InboundType::setLead_Time_in_Days()
     * @uses RFQ_Response_Line_Data_InboundType::setResponse_Line_Memo()
     * @uses RFQ_Response_Line_Data_InboundType::setRFQ_Line_Bid_Response_Data()
     * @uses RFQ_Response_Line_Data_InboundType::setRFQ_Response_Line_Attachment_Data()
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @param bool $no_Bid
     * @param string $response_Line_Description
     * @param float $response_Quantity
     * @param float $response_Price
     * @param float $lead_Time_in_Days
     * @param string $response_Line_Memo
     * @param \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[] $rFQ_Line_Bid_Response_Data
     * @param \StructType\Financials_Attachment_DataType[] $rFQ_Response_Line_Attachment_Data
     */
    public function __construct(\StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null, $no_Bid = null, $response_Line_Description = null, $response_Quantity = null, $response_Price = null, $lead_Time_in_Days = null, $response_Line_Memo = null, array $rFQ_Line_Bid_Response_Data = array(), array $rFQ_Response_Line_Attachment_Data = array())
    {
        $this
            ->setRFQ_Line_Reference($rFQ_Line_Reference)
            ->setNo_Bid($no_Bid)
            ->setResponse_Line_Description($response_Line_Description)
            ->setResponse_Quantity($response_Quantity)
            ->setResponse_Price($response_Price)
            ->setLead_Time_in_Days($lead_Time_in_Days)
            ->setResponse_Line_Memo($response_Line_Memo)
            ->setRFQ_Line_Bid_Response_Data($rFQ_Line_Bid_Response_Data)
            ->setRFQ_Response_Line_Attachment_Data($rFQ_Response_Line_Attachment_Data);
    }
    /**
     * Get RFQ_Line_Reference value
     * @return \StructType\Request_for_Quote_LineObjectType|null
     */
    public function getRFQ_Line_Reference()
    {
        return $this->RFQ_Line_Reference;
    }
    /**
     * Set RFQ_Line_Reference value
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setRFQ_Line_Reference(\StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null)
    {
        $this->RFQ_Line_Reference = $rFQ_Line_Reference;
        return $this;
    }
    /**
     * Get No_Bid value
     * @return bool|null
     */
    public function getNo_Bid()
    {
        return $this->No_Bid;
    }
    /**
     * Set No_Bid value
     * @param bool $no_Bid
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setNo_Bid($no_Bid = null)
    {
        // validation for constraint: boolean
        if (!is_null($no_Bid) && !is_bool($no_Bid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($no_Bid, true), gettype($no_Bid)), __LINE__);
        }
        $this->No_Bid = $no_Bid;
        return $this;
    }
    /**
     * Get Response_Line_Description value
     * @return string|null
     */
    public function getResponse_Line_Description()
    {
        return $this->Response_Line_Description;
    }
    /**
     * Set Response_Line_Description value
     * @param string $response_Line_Description
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setResponse_Line_Description($response_Line_Description = null)
    {
        // validation for constraint: string
        if (!is_null($response_Line_Description) && !is_string($response_Line_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Line_Description, true), gettype($response_Line_Description)), __LINE__);
        }
        $this->Response_Line_Description = $response_Line_Description;
        return $this;
    }
    /**
     * Get Response_Quantity value
     * @return float|null
     */
    public function getResponse_Quantity()
    {
        return $this->Response_Quantity;
    }
    /**
     * Set Response_Quantity value
     * @param float $response_Quantity
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setResponse_Quantity($response_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($response_Quantity) && !(is_float($response_Quantity) || is_numeric($response_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($response_Quantity, true), gettype($response_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($response_Quantity) && mb_strlen(mb_substr($response_Quantity, false !== mb_strpos($response_Quantity, '.') ? mb_strpos($response_Quantity, '.') + 1 : mb_strlen($response_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($response_Quantity, true), mb_strlen(mb_substr($response_Quantity, mb_strpos($response_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($response_Quantity) && $response_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($response_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($response_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $response_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($response_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $response_Quantity))), __LINE__);
        }
        $this->Response_Quantity = $response_Quantity;
        return $this;
    }
    /**
     * Get Response_Price value
     * @return float|null
     */
    public function getResponse_Price()
    {
        return $this->Response_Price;
    }
    /**
     * Set Response_Price value
     * @param float $response_Price
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setResponse_Price($response_Price = null)
    {
        // validation for constraint: float
        if (!is_null($response_Price) && !(is_float($response_Price) || is_numeric($response_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($response_Price, true), gettype($response_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($response_Price) && mb_strlen(mb_substr($response_Price, false !== mb_strpos($response_Price, '.') ? mb_strpos($response_Price, '.') + 1 : mb_strlen($response_Price))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($response_Price, true), mb_strlen(mb_substr($response_Price, mb_strpos($response_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($response_Price) && $response_Price < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($response_Price, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($response_Price) && mb_strlen(preg_replace('/(\D)/', '', $response_Price)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($response_Price, true), mb_strlen(preg_replace('/(\D)/', '', $response_Price))), __LINE__);
        }
        $this->Response_Price = $response_Price;
        return $this;
    }
    /**
     * Get Lead_Time_in_Days value
     * @return float|null
     */
    public function getLead_Time_in_Days()
    {
        return $this->Lead_Time_in_Days;
    }
    /**
     * Set Lead_Time_in_Days value
     * @param float $lead_Time_in_Days
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setLead_Time_in_Days($lead_Time_in_Days = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time_in_Days) && !(is_float($lead_Time_in_Days) || is_numeric($lead_Time_in_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time_in_Days, true), gettype($lead_Time_in_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time_in_Days) && mb_strlen(mb_substr($lead_Time_in_Days, false !== mb_strpos($lead_Time_in_Days, '.') ? mb_strpos($lead_Time_in_Days, '.') + 1 : mb_strlen($lead_Time_in_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time_in_Days, true), mb_strlen(mb_substr($lead_Time_in_Days, mb_strpos($lead_Time_in_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time_in_Days) && $lead_Time_in_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time_in_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time_in_Days) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time_in_Days)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time_in_Days, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time_in_Days))), __LINE__);
        }
        $this->Lead_Time_in_Days = $lead_Time_in_Days;
        return $this;
    }
    /**
     * Get Response_Line_Memo value
     * @return string|null
     */
    public function getResponse_Line_Memo()
    {
        return $this->Response_Line_Memo;
    }
    /**
     * Set Response_Line_Memo value
     * @param string $response_Line_Memo
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setResponse_Line_Memo($response_Line_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($response_Line_Memo) && !is_string($response_Line_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Line_Memo, true), gettype($response_Line_Memo)), __LINE__);
        }
        $this->Response_Line_Memo = $response_Line_Memo;
        return $this;
    }
    /**
     * Get RFQ_Line_Bid_Response_Data value
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[]|null
     */
    public function getRFQ_Line_Bid_Response_Data()
    {
        return $this->RFQ_Line_Bid_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Line_Bid_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Line_Bid_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Line_Bid_Response_DataForArrayConstraintsFromSetRFQ_Line_Bid_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Line_Data_InboundTypeRFQ_Line_Bid_Response_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Line_Data_InboundTypeRFQ_Line_Bid_Response_DataItem instanceof \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType) {
                $invalidValues[] = is_object($rFQ_Response_Line_Data_InboundTypeRFQ_Line_Bid_Response_DataItem) ? get_class($rFQ_Response_Line_Data_InboundTypeRFQ_Line_Bid_Response_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Line_Data_InboundTypeRFQ_Line_Bid_Response_DataItem), var_export($rFQ_Response_Line_Data_InboundTypeRFQ_Line_Bid_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Line_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Line_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[] $rFQ_Line_Bid_Response_Data
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setRFQ_Line_Bid_Response_Data(array $rFQ_Line_Bid_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Line_Bid_Response_DataArrayErrorMessage = self::validateRFQ_Line_Bid_Response_DataForArrayConstraintsFromSetRFQ_Line_Bid_Response_Data($rFQ_Line_Bid_Response_Data))) {
            throw new \InvalidArgumentException($rFQ_Line_Bid_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Line_Bid_Response_Data = $rFQ_Line_Bid_Response_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Line_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType $item
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function addToRFQ_Line_Bid_Response_Data(\StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Line_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Line_Bid_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Response_Line_Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getRFQ_Response_Line_Attachment_Data()
    {
        return $this->RFQ_Response_Line_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Response_Line_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Response_Line_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Response_Line_Attachment_DataForArrayConstraintsFromSetRFQ_Response_Line_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Line_Data_InboundTypeRFQ_Response_Line_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Line_Data_InboundTypeRFQ_Response_Line_Attachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($rFQ_Response_Line_Data_InboundTypeRFQ_Response_Line_Attachment_DataItem) ? get_class($rFQ_Response_Line_Data_InboundTypeRFQ_Response_Line_Attachment_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Line_Data_InboundTypeRFQ_Response_Line_Attachment_DataItem), var_export($rFQ_Response_Line_Data_InboundTypeRFQ_Response_Line_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Response_Line_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Response_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $rFQ_Response_Line_Attachment_Data
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function setRFQ_Response_Line_Attachment_Data(array $rFQ_Response_Line_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Response_Line_Attachment_DataArrayErrorMessage = self::validateRFQ_Response_Line_Attachment_DataForArrayConstraintsFromSetRFQ_Response_Line_Attachment_Data($rFQ_Response_Line_Attachment_Data))) {
            throw new \InvalidArgumentException($rFQ_Response_Line_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Response_Line_Attachment_Data = $rFQ_Response_Line_Attachment_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Response_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\RFQ_Response_Line_Data_InboundType
     */
    public function addToRFQ_Response_Line_Attachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Response_Line_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Response_Line_Attachment_Data[] = $item;
        return $this;
    }
}
