<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Hotel_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Hotel, or change 'Add Only' to 'false' to edit the existing Hotel. | Element containing Hotel reference for update and all Hotel data items
 * @subpackage Structs
 */
class Put_Hotel_RequestType extends AbstractStructBase
{
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hotel Reference
     * - minOccurs: 0
     * @var \StructType\HotelObjectType
     */
    public $Hotel_Reference;
    /**
     * The Hotel_Data
     * Meta information extracted from the WSDL
     * - documentation: Hotel Data
     * @var \StructType\Hotel_DataType
     */
    public $Hotel_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Hotel_RequestType
     * @uses Put_Hotel_RequestType::setHotel_Reference()
     * @uses Put_Hotel_RequestType::setHotel_Data()
     * @uses Put_Hotel_RequestType::setAdd_Only()
     * @uses Put_Hotel_RequestType::setVersion()
     * @param \StructType\HotelObjectType $hotel_Reference
     * @param \StructType\Hotel_DataType $hotel_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\HotelObjectType $hotel_Reference = null, \StructType\Hotel_DataType $hotel_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setHotel_Reference($hotel_Reference)
            ->setHotel_Data($hotel_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * Set Hotel_Reference value
     * @param \StructType\HotelObjectType $hotel_Reference
     * @return \StructType\Put_Hotel_RequestType
     */
    public function setHotel_Reference(\StructType\HotelObjectType $hotel_Reference = null)
    {
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Get Hotel_Data value
     * @return \StructType\Hotel_DataType|null
     */
    public function getHotel_Data()
    {
        return $this->Hotel_Data;
    }
    /**
     * Set Hotel_Data value
     * @param \StructType\Hotel_DataType $hotel_Data
     * @return \StructType\Put_Hotel_RequestType
     */
    public function setHotel_Data(\StructType\Hotel_DataType $hotel_Data = null)
    {
        $this->Hotel_Data = $hotel_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Hotel_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Hotel_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
