<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Procurement_Card_Transaction_Verification_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Procurement Card Transaction Verification response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Procurement_Card_Transaction_Verification_Response_DataType extends AbstractStructBase
{
    /**
     * The Procurement_Card_Transaction_Verification
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes Procurement Card Transaction Verification instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_VerificationType[]
     */
    public $Procurement_Card_Transaction_Verification;
    /**
     * Constructor method for
     * Procurement_Card_Transaction_Verification_Response_DataType
     * @uses Procurement_Card_Transaction_Verification_Response_DataType::setProcurement_Card_Transaction_Verification()
     * @param \StructType\Procurement_Card_Transaction_VerificationType[] $procurement_Card_Transaction_Verification
     */
    public function __construct(array $procurement_Card_Transaction_Verification = array())
    {
        $this
            ->setProcurement_Card_Transaction_Verification($procurement_Card_Transaction_Verification);
    }
    /**
     * Get Procurement_Card_Transaction_Verification value
     * @return \StructType\Procurement_Card_Transaction_VerificationType[]|null
     */
    public function getProcurement_Card_Transaction_Verification()
    {
        return $this->Procurement_Card_Transaction_Verification;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Card_Transaction_Verification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Card_Transaction_Verification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Card_Transaction_VerificationForArrayConstraintsFromSetProcurement_Card_Transaction_Verification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_Response_DataTypeProcurement_Card_Transaction_VerificationItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_Response_DataTypeProcurement_Card_Transaction_VerificationItem instanceof \StructType\Procurement_Card_Transaction_VerificationType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_Response_DataTypeProcurement_Card_Transaction_VerificationItem) ? get_class($procurement_Card_Transaction_Verification_Response_DataTypeProcurement_Card_Transaction_VerificationItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_Response_DataTypeProcurement_Card_Transaction_VerificationItem), var_export($procurement_Card_Transaction_Verification_Response_DataTypeProcurement_Card_Transaction_VerificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Card_Transaction_Verification property can only contain items of type \StructType\Procurement_Card_Transaction_VerificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Card_Transaction_Verification value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_VerificationType[] $procurement_Card_Transaction_Verification
     * @return \StructType\Procurement_Card_Transaction_Verification_Response_DataType
     */
    public function setProcurement_Card_Transaction_Verification(array $procurement_Card_Transaction_Verification = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Card_Transaction_VerificationArrayErrorMessage = self::validateProcurement_Card_Transaction_VerificationForArrayConstraintsFromSetProcurement_Card_Transaction_Verification($procurement_Card_Transaction_Verification))) {
            throw new \InvalidArgumentException($procurement_Card_Transaction_VerificationArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification = $procurement_Card_Transaction_Verification;
        return $this;
    }
    /**
     * Add item to Procurement_Card_Transaction_Verification value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_VerificationType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_Response_DataType
     */
    public function addToProcurement_Card_Transaction_Verification(\StructType\Procurement_Card_Transaction_VerificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Card_Transaction_VerificationType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Card_Transaction_Verification property can only contain items of type \StructType\Procurement_Card_Transaction_VerificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification[] = $item;
        return $this;
    }
}
