<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Tag_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The element that contains the item tag data.
 * @subpackage Structs
 */
class Item_Tag_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The alphanumeric identifier for the item tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the item tag.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the item tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Universal_Item_Identifier_Reference
     * Meta information extracted from the WSDL
     * - documentation: The universal item identifier type for the item tag.
     * - minOccurs: 0
     * @var \StructType\Universal_Item_Identifier_TypeObjectType
     */
    public $Universal_Item_Identifier_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate Item Tag is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Item_Tag_DataType
     * @uses Item_Tag_DataType::setID()
     * @uses Item_Tag_DataType::setName()
     * @uses Item_Tag_DataType::setDescription()
     * @uses Item_Tag_DataType::setUniversal_Item_Identifier_Reference()
     * @uses Item_Tag_DataType::setInactive()
     * @param string $iD
     * @param string $name
     * @param string $description
     * @param \StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Reference
     * @param bool $inactive
     */
    public function __construct($iD = null, $name = null, $description = null, \StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Reference = null, $inactive = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setDescription($description)
            ->setUniversal_Item_Identifier_Reference($universal_Item_Identifier_Reference)
            ->setInactive($inactive);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Item_Tag_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Item_Tag_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Item_Tag_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Universal_Item_Identifier_Reference value
     * @return \StructType\Universal_Item_Identifier_TypeObjectType|null
     */
    public function getUniversal_Item_Identifier_Reference()
    {
        return $this->Universal_Item_Identifier_Reference;
    }
    /**
     * Set Universal_Item_Identifier_Reference value
     * @param \StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Reference
     * @return \StructType\Item_Tag_DataType
     */
    public function setUniversal_Item_Identifier_Reference(\StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Reference = null)
    {
        $this->Universal_Item_Identifier_Reference = $universal_Item_Identifier_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Item_Tag_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
