<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Issue_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Business Process Parameters, Business Asset Reference and Issue details.
 * @subpackage Structs
 */
class Issue_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: There is a pending event for the asset that should be completed before this asset transaction can be processed. | Reference to an existing Business Asset that will be used for the Issue transaction.
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Asset_Issue_Data
     * Meta information extracted from the WSDL
     * - documentation: Data values and flags that will be used to update the Business Asset during the Issue transaction.
     * @var \StructType\Asset_Issue_DataType
     */
    public $Asset_Issue_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Issue_Asset_RequestType
     * @uses Issue_Asset_RequestType::setBusiness_Process_Parameters()
     * @uses Issue_Asset_RequestType::setBusiness_Asset_Reference()
     * @uses Issue_Asset_RequestType::setAsset_Issue_Data()
     * @uses Issue_Asset_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Asset_Issue_DataType $asset_Issue_Data
     * @param string $version
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Asset_Issue_DataType $asset_Issue_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setAsset_Issue_Data($asset_Issue_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Issue_Asset_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Issue_Asset_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Issue_Data value
     * @return \StructType\Asset_Issue_DataType|null
     */
    public function getAsset_Issue_Data()
    {
        return $this->Asset_Issue_Data;
    }
    /**
     * Set Asset_Issue_Data value
     * @param \StructType\Asset_Issue_DataType $asset_Issue_Data
     * @return \StructType\Issue_Asset_RequestType
     */
    public function setAsset_Issue_Data(\StructType\Asset_Issue_DataType $asset_Issue_Data = null)
    {
        $this->Asset_Issue_Data = $asset_Issue_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Issue_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
