<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Useful_Life_for_Reclassify_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This data for useful life per book
 * @subpackage Structs
 */
class Asset_Useful_Life_for_Reclassify_DataType extends AbstractStructBase
{
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to asset book of which you want to change useful life.
     * @var \StructType\Asset_BookObjectType
     */
    public $Asset_Book_Reference;
    /**
     * The Proposed_Useful_Life
     * Meta information extracted from the WSDL
     * - documentation: Reference to Useful Life for the specified book.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Proposed_Useful_Life;
    /**
     * Constructor method for Asset_Useful_Life_for_Reclassify_DataType
     * @uses Asset_Useful_Life_for_Reclassify_DataType::setAsset_Book_Reference()
     * @uses Asset_Useful_Life_for_Reclassify_DataType::setProposed_Useful_Life()
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @param float $proposed_Useful_Life
     */
    public function __construct(\StructType\Asset_BookObjectType $asset_Book_Reference = null, $proposed_Useful_Life = null)
    {
        $this
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setProposed_Useful_Life($proposed_Useful_Life);
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * Set Asset_Book_Reference value
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @return \StructType\Asset_Useful_Life_for_Reclassify_DataType
     */
    public function setAsset_Book_Reference(\StructType\Asset_BookObjectType $asset_Book_Reference = null)
    {
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Get Proposed_Useful_Life value
     * @return float|null
     */
    public function getProposed_Useful_Life()
    {
        return $this->Proposed_Useful_Life;
    }
    /**
     * Set Proposed_Useful_Life value
     * @param float $proposed_Useful_Life
     * @return \StructType\Asset_Useful_Life_for_Reclassify_DataType
     */
    public function setProposed_Useful_Life($proposed_Useful_Life = null)
    {
        // validation for constraint: float
        if (!is_null($proposed_Useful_Life) && !(is_float($proposed_Useful_Life) || is_numeric($proposed_Useful_Life))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proposed_Useful_Life, true), gettype($proposed_Useful_Life)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($proposed_Useful_Life) && mb_strlen(mb_substr($proposed_Useful_Life, false !== mb_strpos($proposed_Useful_Life, '.') ? mb_strpos($proposed_Useful_Life, '.') + 1 : mb_strlen($proposed_Useful_Life))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($proposed_Useful_Life, true), mb_strlen(mb_substr($proposed_Useful_Life, mb_strpos($proposed_Useful_Life, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($proposed_Useful_Life) && $proposed_Useful_Life < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($proposed_Useful_Life, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($proposed_Useful_Life) && mb_strlen(preg_replace('/(\D)/', '', $proposed_Useful_Life)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($proposed_Useful_Life, true), mb_strlen(preg_replace('/(\D)/', '', $proposed_Useful_Life))), __LINE__);
        }
        $this->Proposed_Useful_Life = $proposed_Useful_Life;
        return $this;
    }
}
