<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Worktag Split Template Item Data
 * @subpackage Structs
 */
class Worktag_Split_Template_Item_DataType extends AbstractStructBase
{
    /**
     * The Worktag_Split_Template_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Item Reference
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_Template_ItemObjectType
     */
    public $Worktag_Split_Template_Item_Reference;
    /**
     * The Line_Order
     * Meta information extracted from the WSDL
     * - documentation: Line Order for Worktag Split Template Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Order;
    /**
     * The Percentage_by_Amount_for_Distribution_Line
     * Meta information extracted from the WSDL
     * - documentation: Distribution Percentage for Worktag Split Template Item
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - totalDigits: 9
     * @var float
     */
    public $Percentage_by_Amount_for_Distribution_Line;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for Worktag Split Template Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Billable Flag at Worktag Split Template Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * Constructor method for Worktag_Split_Template_Item_DataType
     * @uses Worktag_Split_Template_Item_DataType::setWorktag_Split_Template_Item_Reference()
     * @uses Worktag_Split_Template_Item_DataType::setLine_Order()
     * @uses Worktag_Split_Template_Item_DataType::setPercentage_by_Amount_for_Distribution_Line()
     * @uses Worktag_Split_Template_Item_DataType::setMemo()
     * @uses Worktag_Split_Template_Item_DataType::setWorktag_Reference()
     * @uses Worktag_Split_Template_Item_DataType::setBillable()
     * @param \StructType\Worktag_Split_Template_ItemObjectType $worktag_Split_Template_Item_Reference
     * @param string $line_Order
     * @param float $percentage_by_Amount_for_Distribution_Line
     * @param string $memo
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param bool $billable
     */
    public function __construct(\StructType\Worktag_Split_Template_ItemObjectType $worktag_Split_Template_Item_Reference = null, $line_Order = null, $percentage_by_Amount_for_Distribution_Line = null, $memo = null, array $worktag_Reference = array(), $billable = null)
    {
        $this
            ->setWorktag_Split_Template_Item_Reference($worktag_Split_Template_Item_Reference)
            ->setLine_Order($line_Order)
            ->setPercentage_by_Amount_for_Distribution_Line($percentage_by_Amount_for_Distribution_Line)
            ->setMemo($memo)
            ->setWorktag_Reference($worktag_Reference)
            ->setBillable($billable);
    }
    /**
     * Get Worktag_Split_Template_Item_Reference value
     * @return \StructType\Worktag_Split_Template_ItemObjectType|null
     */
    public function getWorktag_Split_Template_Item_Reference()
    {
        return $this->Worktag_Split_Template_Item_Reference;
    }
    /**
     * Set Worktag_Split_Template_Item_Reference value
     * @param \StructType\Worktag_Split_Template_ItemObjectType $worktag_Split_Template_Item_Reference
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function setWorktag_Split_Template_Item_Reference(\StructType\Worktag_Split_Template_ItemObjectType $worktag_Split_Template_Item_Reference = null)
    {
        $this->Worktag_Split_Template_Item_Reference = $worktag_Split_Template_Item_Reference;
        return $this;
    }
    /**
     * Get Line_Order value
     * @return string|null
     */
    public function getLine_Order()
    {
        return $this->Line_Order;
    }
    /**
     * Set Line_Order value
     * @param string $line_Order
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function setLine_Order($line_Order = null)
    {
        // validation for constraint: string
        if (!is_null($line_Order) && !is_string($line_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Order, true), gettype($line_Order)), __LINE__);
        }
        $this->Line_Order = $line_Order;
        return $this;
    }
    /**
     * Get Percentage_by_Amount_for_Distribution_Line value
     * @return float|null
     */
    public function getPercentage_by_Amount_for_Distribution_Line()
    {
        return $this->Percentage_by_Amount_for_Distribution_Line;
    }
    /**
     * Set Percentage_by_Amount_for_Distribution_Line value
     * @param float $percentage_by_Amount_for_Distribution_Line
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function setPercentage_by_Amount_for_Distribution_Line($percentage_by_Amount_for_Distribution_Line = null)
    {
        // validation for constraint: float
        if (!is_null($percentage_by_Amount_for_Distribution_Line) && !(is_float($percentage_by_Amount_for_Distribution_Line) || is_numeric($percentage_by_Amount_for_Distribution_Line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage_by_Amount_for_Distribution_Line, true), gettype($percentage_by_Amount_for_Distribution_Line)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($percentage_by_Amount_for_Distribution_Line) && mb_strlen(mb_substr($percentage_by_Amount_for_Distribution_Line, false !== mb_strpos($percentage_by_Amount_for_Distribution_Line, '.') ? mb_strpos($percentage_by_Amount_for_Distribution_Line, '.') + 1 : mb_strlen($percentage_by_Amount_for_Distribution_Line))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($percentage_by_Amount_for_Distribution_Line, true), mb_strlen(mb_substr($percentage_by_Amount_for_Distribution_Line, mb_strpos($percentage_by_Amount_for_Distribution_Line, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($percentage_by_Amount_for_Distribution_Line) && mb_strlen(preg_replace('/(\D)/', '', $percentage_by_Amount_for_Distribution_Line)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($percentage_by_Amount_for_Distribution_Line, true), mb_strlen(preg_replace('/(\D)/', '', $percentage_by_Amount_for_Distribution_Line))), __LINE__);
        }
        $this->Percentage_by_Amount_for_Distribution_Line = $percentage_by_Amount_for_Distribution_Line;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_Item_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_Item_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($worktag_Split_Template_Item_DataTypeWorktag_ReferenceItem) ? get_class($worktag_Split_Template_Item_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_Item_DataTypeWorktag_ReferenceItem), var_export($worktag_Split_Template_Item_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Worktag_Split_Template_Item_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
}
