<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Supplier Classifications Request
 * @subpackage Structs
 */
class Supplier_Classification_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Delivered_Custom_Supplier_Classification_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Custom Supplier Classification Category (Workday Owned)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType[]
     */
    public $Delivered_Custom_Supplier_Classification_Category_Reference;
    /**
     * Constructor method for Supplier_Classification_Request_CriteriaType
     * @uses Supplier_Classification_Request_CriteriaType::setDelivered_Custom_Supplier_Classification_Category_Reference()
     * @param \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType[] $delivered_Custom_Supplier_Classification_Category_Reference
     */
    public function __construct(array $delivered_Custom_Supplier_Classification_Category_Reference = array())
    {
        $this
            ->setDelivered_Custom_Supplier_Classification_Category_Reference($delivered_Custom_Supplier_Classification_Category_Reference);
    }
    /**
     * Get Delivered_Custom_Supplier_Classification_Category_Reference value
     * @return \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType[]|null
     */
    public function getDelivered_Custom_Supplier_Classification_Category_Reference()
    {
        return $this->Delivered_Custom_Supplier_Classification_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivered_Custom_Supplier_Classification_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivered_Custom_Supplier_Classification_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDelivered_Custom_Supplier_Classification_Category_ReferenceForArrayConstraintsFromSetDelivered_Custom_Supplier_Classification_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Request_CriteriaTypeDelivered_Custom_Supplier_Classification_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Request_CriteriaTypeDelivered_Custom_Supplier_Classification_Category_ReferenceItem instanceof \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType) {
                $invalidValues[] = is_object($supplier_Classification_Request_CriteriaTypeDelivered_Custom_Supplier_Classification_Category_ReferenceItem) ? get_class($supplier_Classification_Request_CriteriaTypeDelivered_Custom_Supplier_Classification_Category_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Classification_Request_CriteriaTypeDelivered_Custom_Supplier_Classification_Category_ReferenceItem), var_export($supplier_Classification_Request_CriteriaTypeDelivered_Custom_Supplier_Classification_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivered_Custom_Supplier_Classification_Category_Reference property can only contain items of type \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivered_Custom_Supplier_Classification_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType[] $delivered_Custom_Supplier_Classification_Category_Reference
     * @return \StructType\Supplier_Classification_Request_CriteriaType
     */
    public function setDelivered_Custom_Supplier_Classification_Category_Reference(array $delivered_Custom_Supplier_Classification_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($delivered_Custom_Supplier_Classification_Category_ReferenceArrayErrorMessage = self::validateDelivered_Custom_Supplier_Classification_Category_ReferenceForArrayConstraintsFromSetDelivered_Custom_Supplier_Classification_Category_Reference($delivered_Custom_Supplier_Classification_Category_Reference))) {
            throw new \InvalidArgumentException($delivered_Custom_Supplier_Classification_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Delivered_Custom_Supplier_Classification_Category_Reference = $delivered_Custom_Supplier_Classification_Category_Reference;
        return $this;
    }
    /**
     * Add item to Delivered_Custom_Supplier_Classification_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType $item
     * @return \StructType\Supplier_Classification_Request_CriteriaType
     */
    public function addToDelivered_Custom_Supplier_Classification_Category_Reference(\StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Delivered_Custom_Supplier_Classification_Category_Reference property can only contain items of type \StructType\Custom_Supplier_Classification_Category__Workday_Owned_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivered_Custom_Supplier_Classification_Category_Reference[] = $item;
        return $this;
    }
}
