<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Asset_Book_Rules_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Response on the Put operation.
 * @subpackage Structs
 */
class Put_Asset_Book_Rules_ResponseType extends AbstractStructBase
{
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing asset book to which the asset book rule data applies
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType
     */
    public $Asset_Book_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Asset_Book_Rules_ResponseType
     * @uses Put_Asset_Book_Rules_ResponseType::setAsset_Book_Reference()
     * @uses Put_Asset_Book_Rules_ResponseType::setVersion()
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @param string $version
     */
    public function __construct(\StructType\Asset_BookObjectType $asset_Book_Reference = null, $version = null)
    {
        $this
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setVersion($version);
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * Set Asset_Book_Reference value
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @return \StructType\Put_Asset_Book_Rules_ResponseType
     */
    public function setAsset_Book_Reference(\StructType\Asset_BookObjectType $asset_Book_Reference = null)
    {
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Asset_Book_Rules_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
