<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Acknowledgement_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Document Date On or After must be earlier than Document Date On or Before | Organization Reference must be Companies or Company Hierarchies | The Purchase Order Acknowledgement Request Criteria element contains criteria to retrieve
 * Purchase Order Acknowledgements.
 * @subpackage Structs
 */
class Purchase_Order_Acknowledgement_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Acknowledgement_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Acknowledgement Type for the Purchase Order Acknowledgement. Examples of valid statuses are Accepted, Rejected, and Partially Acknowledged.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PO_Acknowledgement_StatusObjectType[]
     */
    public $Acknowledgement_Type_Reference;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to the Document Status on the Purchase Order Acknowledgement.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Purchase_Order_Acknowledgement_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Acknowledgement Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Acknowledgement_Date_On_or_After;
    /**
     * The Purchase_Order_Acknowledgement_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Acknowledgement Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Acknowledgement_Date_On_or_Before;
    /**
     * Constructor method for Purchase_Order_Acknowledgement_Request_CriteriaType
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setOrganization_Reference()
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setSupplier_Reference()
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setAcknowledgement_Type_Reference()
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setDocument_Status_Reference()
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setPurchase_Order_Acknowledgement_Date_On_or_After()
     * @uses Purchase_Order_Acknowledgement_Request_CriteriaType::setPurchase_Order_Acknowledgement_Date_On_or_Before()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @param \StructType\PO_Acknowledgement_StatusObjectType[] $acknowledgement_Type_Reference
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param string $purchase_Order_Acknowledgement_Date_On_or_After
     * @param string $purchase_Order_Acknowledgement_Date_On_or_Before
     */
    public function __construct(array $organization_Reference = array(), array $supplier_Reference = array(), array $acknowledgement_Type_Reference = array(), \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $purchase_Order_Acknowledgement_Date_On_or_After = null, $purchase_Order_Acknowledgement_Date_On_or_Before = null)
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setAcknowledgement_Type_Reference($acknowledgement_Type_Reference)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setPurchase_Order_Acknowledgement_Date_On_or_After($purchase_Order_Acknowledgement_Date_On_or_After)
            ->setPurchase_Order_Acknowledgement_Date_On_or_Before($purchase_Order_Acknowledgement_Date_On_or_Before);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($purchase_Order_Acknowledgement_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_Request_CriteriaTypeOrganization_ReferenceItem), var_export($purchase_Order_Acknowledgement_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($purchase_Order_Acknowledgement_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_Request_CriteriaTypeSupplier_ReferenceItem), var_export($purchase_Order_Acknowledgement_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Acknowledgement_Type_Reference value
     * @return \StructType\PO_Acknowledgement_StatusObjectType[]|null
     */
    public function getAcknowledgement_Type_Reference()
    {
        return $this->Acknowledgement_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAcknowledgement_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcknowledgement_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcknowledgement_Type_ReferenceForArrayConstraintsFromSetAcknowledgement_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_Request_CriteriaTypeAcknowledgement_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_Request_CriteriaTypeAcknowledgement_Type_ReferenceItem instanceof \StructType\PO_Acknowledgement_StatusObjectType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_Request_CriteriaTypeAcknowledgement_Type_ReferenceItem) ? get_class($purchase_Order_Acknowledgement_Request_CriteriaTypeAcknowledgement_Type_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_Request_CriteriaTypeAcknowledgement_Type_ReferenceItem), var_export($purchase_Order_Acknowledgement_Request_CriteriaTypeAcknowledgement_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Acknowledgement_Type_Reference property can only contain items of type \StructType\PO_Acknowledgement_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Acknowledgement_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\PO_Acknowledgement_StatusObjectType[] $acknowledgement_Type_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setAcknowledgement_Type_Reference(array $acknowledgement_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($acknowledgement_Type_ReferenceArrayErrorMessage = self::validateAcknowledgement_Type_ReferenceForArrayConstraintsFromSetAcknowledgement_Type_Reference($acknowledgement_Type_Reference))) {
            throw new \InvalidArgumentException($acknowledgement_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Acknowledgement_Type_Reference = $acknowledgement_Type_Reference;
        return $this;
    }
    /**
     * Add item to Acknowledgement_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\PO_Acknowledgement_StatusObjectType $item
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function addToAcknowledgement_Type_Reference(\StructType\PO_Acknowledgement_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PO_Acknowledgement_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Acknowledgement_Type_Reference property can only contain items of type \StructType\PO_Acknowledgement_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Acknowledgement_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Acknowledgement_Date_On_or_After value
     * @return string|null
     */
    public function getPurchase_Order_Acknowledgement_Date_On_or_After()
    {
        return $this->Purchase_Order_Acknowledgement_Date_On_or_After;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Date_On_or_After value
     * @param string $purchase_Order_Acknowledgement_Date_On_or_After
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setPurchase_Order_Acknowledgement_Date_On_or_After($purchase_Order_Acknowledgement_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Acknowledgement_Date_On_or_After) && !is_string($purchase_Order_Acknowledgement_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Acknowledgement_Date_On_or_After, true), gettype($purchase_Order_Acknowledgement_Date_On_or_After)), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Date_On_or_After = $purchase_Order_Acknowledgement_Date_On_or_After;
        return $this;
    }
    /**
     * Get Purchase_Order_Acknowledgement_Date_On_or_Before value
     * @return string|null
     */
    public function getPurchase_Order_Acknowledgement_Date_On_or_Before()
    {
        return $this->Purchase_Order_Acknowledgement_Date_On_or_Before;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Date_On_or_Before value
     * @param string $purchase_Order_Acknowledgement_Date_On_or_Before
     * @return \StructType\Purchase_Order_Acknowledgement_Request_CriteriaType
     */
    public function setPurchase_Order_Acknowledgement_Date_On_or_Before($purchase_Order_Acknowledgement_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Acknowledgement_Date_On_or_Before) && !is_string($purchase_Order_Acknowledgement_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Acknowledgement_Date_On_or_Before, true), gettype($purchase_Order_Acknowledgement_Date_On_or_Before)), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Date_On_or_Before = $purchase_Order_Acknowledgement_Date_On_or_Before;
        return $this;
    }
}
